/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.common.ui.nodes.editors;

import java.util.ResourceBundle;
import java.awt.Dimension;
import java.util.logging.StreamHandler;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.j2ee.common.FQNSearch;

import org.openide.util.NbBundle;

/**
 * This is copy of org.netbeans.modules.java.ui.nodes.editors.MethodParameterPanel
 *
 * @see org.netbeans.modules.java.ui.nodes.editors.MethodParameterPanel
 * @author Martin Adamek
 */
class MethodParameterPanel extends javax.swing.JPanel {
    /** Resource bundle. */
    static final ResourceBundle bundle = NbBundle.getBundle(MethodParameterPanel.class);

    /** This array is used in type combo box. */
    static final String[] COMMON_TYPES = TypeEditor.LVALUE_TYPES; 

    /** Creates new form ParamPanel */
    public MethodParameterPanel() {
        initComponents ();

        typeLabel.setDisplayedMnemonic(bundle.getString("CTL_Type_Mnemonic").charAt(0)); // NOI18N
        nameLabel.setDisplayedMnemonic(bundle.getString("CTL_Name_Mnemonic").charAt(0)); // NOI18N
        finalCheckBox.setMnemonic(bundle.getString("CTL_Final_Mnemonic").charAt(0)); // NOI18N

        getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_MethodParameterPanel")); // NOI18N
        typeLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_Type")); // NOI18N
        nameLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_Name")); // NOI18N
        finalCheckBox.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_Final")); // NOI18N
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        typeLabel = new javax.swing.JLabel();
        nameLabel = new javax.swing.JLabel();
        nameTextField = new javax.swing.JTextField();
        finalCheckBox = new javax.swing.JCheckBox();
        jButton1 = new javax.swing.JButton();
        typeCombo = new JComboBox(COMMON_TYPES);

        setLayout(new java.awt.GridBagLayout());

        setBorder(javax.swing.BorderFactory.createEmptyBorder(12, 12, 0, 11));
        setMinimumSize(new java.awt.Dimension(500, 87));
        typeLabel.setLabelFor(typeCombo);
        typeLabel.setText(bundle.getString("CTL_Type"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 6, 8);
        add(typeLabel, gridBagConstraints);

        nameLabel.setLabelFor(nameTextField);
        nameLabel.setText(bundle.getString("CTL_Name"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 6, 8);
        add(nameLabel, gridBagConstraints);

        nameTextField.setColumns(20);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 6, 0);
        add(nameTextField, gridBagConstraints);

        finalCheckBox.setText(bundle.getString("CTL_Final"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.weightx = 1.0;
        add(finalCheckBox, gridBagConstraints);

        jButton1.setMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/common/ui/nodes/editors/Bundle").getString("MN_Browse").charAt(0));
        jButton1.setText(org.openide.util.NbBundle.getMessage(MethodParameterPanel.class, "LBL_Browse"));
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 6, 0);
        add(jButton1, gridBagConstraints);

        typeCombo.setEditable(true);
        typeCombo.setSelectedItem("String");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 6, 8);
        add(typeCombo, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        SwingUtilities.invokeLater (new Runnable() {
            public void run() {
                FQNSearch.showFastOpen((JTextComponent)typeCombo.getEditor().getEditorComponent());
            }
        });
    }//GEN-LAST:event_jButton1ActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    protected javax.swing.JCheckBox finalCheckBox;
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel nameLabel;
    protected javax.swing.JTextField nameTextField;
    private javax.swing.JComboBox typeCombo;
    private javax.swing.JLabel typeLabel;
    // End of variables declaration//GEN-END:variables

    protected JTextComponent getTypeTextComponent() {
        return (JTextComponent) typeCombo.getEditor().getEditorComponent();
    }    
}
