/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.common.ui.nodes.editors;

import java.beans.*;
import java.util.ResourceBundle;
import javax.swing.*;

import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;


// XXX Copy from openide/src  org.openide.explorer.propertysheeet.editors.ObjectArrayPanel.
/**
 * This is copy of org.netbeans.modules.java.ui.nodes.editors.ObjectArrayPanel2
 * only setting selected index in xxxButtonActionPerformed methods is changed (#58647)
 *
 * @see org.netbeans.modules.java.ui.nodes.editors.ObjectArrayPanel2
 * @author Martin Adamek
 */
abstract class ObjectArrayPanel2 extends javax.swing.JPanel {
    static final String PROP_MNEMONIC_ADD = "mnemonic_Add"; // NOI18N
    static final String PROP_MNEMONIC_REMOVE = "mnemonic_Remove"; // NOI18N
    static final String PROP_MNEMONIC_UP = "mnemonic_Up"; // NOI18N
    static final String PROP_MNEMONIC_DOWN = "mnemonic_Down"; // NOI18N
    static final String PROP_MNEMONIC_EDIT = "mnemonic_Edit"; // NOI18N
    static final String PROP_MNEMONIC_LIST = "mnemonic_List"; // NOI18N
    static final String PROP_LABEL_LIST = "label_List"; // NOI18N
    
    /** Resource bundle. */
    static final ResourceBundle bundle = NbBundle.getBundle(ObjectArrayPanel2.class);

    /** The list model for the edited data. */
    protected DefaultListModel model;
    
    protected final boolean isWritable;

    /** Creates new form ListPanel */
    public ObjectArrayPanel2() {
        this(true);
    }
    
    public ObjectArrayPanel2(boolean isWritable) {
        this.isWritable = isWritable;
        initComponents ();

        model = new DefaultListModel();
        list.setModel(model);
        updateButtons();

        getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ObjectArrayPanel")); // NOI18N
        list.getAccessibleContext().setAccessibleName(bundle.getString("ACS_ObjectArrayPanel_List")); // NOI18N
        list.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ObjectArrayPanel_List")); // NOI18N
        upButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_MoveUp")); // NOI18N
        downButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_MoveDown")); // NOI18N
        addButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_Add")); // NOI18N
        removeButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_Remove")); // NOI18N
        changeButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_Change")); // NOI18N
    }
    
    /* package private */void setMnemonics(PropertyEnv env) {
        FeatureDescriptor desc = env.getFeatureDescriptor();
        Object o = desc.getValue(PROP_MNEMONIC_ADD);
        if (o instanceof String) {
            addButton.setMnemonic(((String)o).charAt(0));
        } else {
            addButton.setMnemonic(bundle.getString("CTL_Add_Mnemonic").charAt(0)); // NOI18N
        }
        o = desc.getValue(PROP_MNEMONIC_REMOVE);
        if (o instanceof String) {
            removeButton.setMnemonic(((String)o).charAt(0));
        } else {
            removeButton.setMnemonic(bundle.getString("CTL_Remove_Mnemonic").charAt(0)); // NOI18N
        }
        o = desc.getValue(PROP_MNEMONIC_EDIT);
        if (o instanceof String) {
            changeButton.setMnemonic(((String)o).charAt(0));
        } else {
            changeButton.setMnemonic(bundle.getString("CTL_Change_Mnemonic").charAt(0)); // NOI18N
        }
        o = desc.getValue(PROP_MNEMONIC_UP);
        if (o instanceof String) {
            upButton.setMnemonic(((String)o).charAt(0));
        } else {
            upButton.setMnemonic(bundle.getString("CTL_MoveUp_Mnemonic").charAt(0)); // NOI18N
        }
        o = desc.getValue(PROP_MNEMONIC_DOWN);
        if (o instanceof String) {
            downButton.setMnemonic(((String)o).charAt(0));
        } else {
            downButton.setMnemonic(bundle.getString("CTL_MoveDown_Mnemonic").charAt(0)); // NOI18N
        }
        o = desc.getValue(PROP_LABEL_LIST);
        if (o instanceof String) {
            jLabel1.setText((String)o);
            o = desc.getValue(PROP_MNEMONIC_LIST);
            if (o instanceof String) {
                jLabel1.setDisplayedMnemonic(((String)o).charAt(0));
            }
        } else {
            jLabel1.setText(bundle.getString("LAB_ObjectList")); // NOI18N
            jLabel1.setDisplayedMnemonic(bundle.getString("MNEMO_ObjectList").charAt(0)); // NOI18N
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        list = new javax.swing.JList();
        upButton = new javax.swing.JButton();
        downButton = new javax.swing.JButton();
        addButton = new javax.swing.JButton();
        removeButton = new javax.swing.JButton();
        changeButton = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        jLabel1.setLabelFor(list);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 5, 0);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weighty = 1.0;
        add(jLabel1, gridBagConstraints);

        jScrollPane1.setPreferredSize(new java.awt.Dimension(200, 3));
        list.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        list.setVisibleRowCount(3);
        list.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                ObjectArrayPanel2.this.listValueChanged(evt);
            }
        });
        list.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ObjectArrayPanel2.this.listMouseClicked(evt);
            }
        });

        jScrollPane1.setViewportView(list);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 0, 11);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jScrollPane1, gridBagConstraints);

        upButton.setText(bundle.getString("CTL_MoveUp"));
        upButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ObjectArrayPanel2.this.upButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 11);
        gridBagConstraints.weighty = 1.0;
        add(upButton, gridBagConstraints);

        downButton.setText(bundle.getString("CTL_MoveDown"));
        downButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ObjectArrayPanel2.this.downButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 11);
        gridBagConstraints.weighty = 1.0;
        add(downButton, gridBagConstraints);

        addButton.setText(bundle.getString("CTL_Add"));
        addButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ObjectArrayPanel2.this.addButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 5, 11);
        gridBagConstraints.weighty = 1.0;
        add(addButton, gridBagConstraints);

        removeButton.setText(bundle.getString("CTL_Remove"));
        removeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ObjectArrayPanel2.this.removeButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 11, 11);
        gridBagConstraints.weighty = 1.0;
        add(removeButton, gridBagConstraints);

        changeButton.setText(bundle.getString("CTL_Change"));
        changeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ObjectArrayPanel2.this.changeButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 11);
        gridBagConstraints.weighty = 1.0;
        add(changeButton, gridBagConstraints);

    }//GEN-END:initComponents

    private void listMouseClicked (java.awt.event.MouseEvent evt) {//GEN-FIRST:event_listMouseClicked
        if (org.openide.awt.MouseUtils.isDoubleClick(evt) && this.isWritable) {
            int selIndex = list.getSelectedIndex();
            if (selIndex != -1) {
                Object newValue = editValue(model.getElementAt(selIndex));
                if (newValue != null) {
                    model.setElementAt(newValue,selIndex);
                    modelChanged();
                    updateButtons();
                }
            }
        }
    }//GEN-LAST:event_listMouseClicked

    private void listValueChanged (javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_listValueChanged
        updateButtons();
    }//GEN-LAST:event_listValueChanged

    private void downButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_downButtonActionPerformed
        int selIndex = list.getSelectedIndex();
        modelChanged();
        updateButtons();
        model.set(selIndex + 1, model.set(selIndex, model.getElementAt(selIndex + 1)));
        list.setSelectedIndex(selIndex + 1);
    }//GEN-LAST:event_downButtonActionPerformed

    private void upButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_upButtonActionPerformed
        int selIndex = list.getSelectedIndex();
        modelChanged();
        updateButtons();
        model.set(selIndex - 1, model.set(selIndex, model.getElementAt(selIndex - 1)));
        list.setSelectedIndex(selIndex - 1);
    }//GEN-LAST:event_upButtonActionPerformed

    private void changeButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_changeButtonActionPerformed
        int selIndex = list.getSelectedIndex();
        Object newValue = editValue(model.getElementAt(selIndex));
        if (newValue != null) {
            model.setElementAt(newValue,selIndex);
            modelChanged();
            updateButtons();
            list.setSelectedIndex(selIndex);
        }
    }//GEN-LAST:event_changeButtonActionPerformed

    private void removeButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeButtonActionPerformed
        int selIndex = list.getSelectedIndex();
        model.remove(selIndex);
        modelChanged();
        updateButtons();
        int size = model.size();
        if (size > 0) {
            selIndex = Math.min(size - 1, selIndex);
            list.setSelectedIndex(selIndex);
        }
    }//GEN-LAST:event_removeButtonActionPerformed

    private void addButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addButtonActionPerformed
        Object newValue = insertNewValue();
        if (newValue != null) {
            model.addElement(newValue);
            modelChanged();
            updateButtons();
            list.setSelectedIndex(model.size() - 1);
        }
    }//GEN-LAST:event_addButtonActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton addButton;
    private javax.swing.JButton downButton;
    private javax.swing.JList list;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JButton changeButton;
    private javax.swing.JButton upButton;
    private javax.swing.JButton removeButton;
    // End of variables declaration//GEN-END:variables

    /** Method for subclasses.
    * @return the main JList component in the panel
    */
    protected JList getListComponent() {
        return list;
    }

    /** Updates the 'enable' status of the buttons in the panel.
    */
    private void updateButtons() {
        boolean isEmpty = model.isEmpty();
        int selIndex = list.getSelectedIndex();
        boolean isSelected = (selIndex != -1) && this.isWritable;
        
        addButton.setEnabled(this.isWritable);
        removeButton.setEnabled(isSelected);
        changeButton.setEnabled(isSelected);
        upButton.setEnabled(isSelected && (selIndex > 0));
        downButton.setEnabled(isSelected && (selIndex < model.size() - 1));
    }

    /** Ask user for new value.
    * @return new value or <CODE>null</CODE> when 
    *    operation was canceled.
    */
    protected abstract Object insertNewValue();

    /** Ask user for edit value.
    * @param oldValue The previous value to be edited
    * @return new value or <CODE>null</CODE> when 
    *    operation was canceled.
    */
    protected abstract Object editValue(Object oldValue);

    /** Notification about the changes in the data array.
    */
    protected void modelChanged() {
    }
}
