/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification;

import org.netbeans.jmi.javamodel.Element;
import org.openide.util.NbBundle;

import java.util.Collections;
import java.util.List;

/**
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public abstract class AbstractRule implements Rule {

    protected List<? extends Predicate> preConditions;

    protected Predicate predicate;

    protected AbstractRule() {
        preConditions = Collections.emptyList();
    }

    protected AbstractRule(Predicate assertion) {
        this.predicate = assertion;
        preConditions = Collections.emptyList();
    }

    protected AbstractRule(
            Predicate assertion,
            List<? extends Predicate> preConditions) {
        this.predicate = assertion;
        this.preConditions = preConditions;
    }
    
    public JEEVerificationProblemMark.Severity getSeverity(){
        return JEEVerificationProblemMark.Severity.ERROR;
    }

    public Problem apply(Element subject, ProblemFinderContext ctx) {
        if (isApplicable(subject, ctx)) {
            if (!predicate.evaluate(subject)) { // found a violation
                return createProblem(ctx, subject);
            }
        }
        return null;
    }

    protected Problem createProblem(ProblemFinderContext ctx, Element subject) {
        JEEVerificationContextInfo problemContext =
                new JEEVerificationContextInfo(ctx.getMainJavaClass());
        problemContext.setElement(subject);
        return new ProblemImpl(problemContext,
                NbBundle.getMessage(this.getClass(),
                        getMessageKey(),
                        getMessageParameters()));
    }

    protected abstract String getMessageKey();

    protected Object[] getMessageParameters() {
        return null;
    }

    protected boolean isApplicable(Element subject, ProblemFinderContext ctx) {
        boolean result = true;
        for (Predicate pred : preConditions) {
            result = result && pred.evaluate(subject);
        }
        return result;
    }

    /**
     * Implementation of reset()
     * @see Rule#reset()
     */
    public void reset() {
        // no op implementation.
    }
}
