/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification;

import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;

/**
 *
 * @author Tomasz Slota
 */
public class JEEVerificationContextInfo {
    
    private JavaClass javaClass;
    private Field field;
    private Element element;
    
    /** Creates a new instance of JEEProblemContextInfo */
    public JEEVerificationContextInfo(JavaClass javaClass) {
        this.javaClass = javaClass;
    }
    
    public JavaClass getJavaClass() {
        return javaClass;
    }
    
    public void setJavaClass(JavaClass javaClass) {
        this.javaClass = javaClass;
    }
    
    /**
     * use element instead
     */
    @Deprecated
            public Field getField() {
        return field;
    }
    
    /**
     * use element instead
     */
    @Deprecated
            public void setField(Field field) {
        this.field = field;
    }
    
    public Element getElement() {
        return element;
    }
    
    public void setElement(Element element) {
        this.element = element;
    }
    
    @Override public boolean equals(Object obj){
        
        if (obj instanceof JEEVerificationContextInfo){
            JEEVerificationContextInfo vCtxInfo = (JEEVerificationContextInfo)obj;
            
            return getElement() == vCtxInfo.getElement()
            && getJavaClass() == vCtxInfo.getJavaClass() && getField() == vCtxInfo.getField();
        }
        
        return false;
    }
    
    @Override public int hashCode(){
        return 1; // satisfy the hashCode() contract the cheapest way
    }
}
