/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.verification;

import org.netbeans.modules.editor.hints.spi.Hint;

/**
 *
 * @author tomslot
 */
public abstract class JEEVerificationHint extends Hint {
    private JEEVerificationContextInfo problemContext;
    
    /** Creates a new instance of JEEHint */
    public JEEVerificationHint(JEEVerificationContextInfo problemContext) {
        this.problemContext = problemContext;
    }

    public JEEVerificationContextInfo getProblemContext() {
        return problemContext;
    }

    public void setProblemContext(JEEVerificationContextInfo problemContext) {
        this.problemContext = problemContext;
    }
    
    @Override public int hashCode(){
        return 1; // satisfy the hashCode() contract the cheapest way
    }
    
    @Override public boolean equals(Object obj){
        if (getClass().equals(obj.getClass())){
            JEEVerificationHint hint = JEEVerificationHint.class.cast(obj);
            
            if (hint.getProblemContext().equals(getProblemContext())){
                return true;
            }
        }
        
        return false;
    }
}
