/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.verification;

import static org.netbeans.modules.j2ee.verification.persistence.BeanAccessType.*;
import org.netbeans.editor.BaseDocument;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.EntityMappings;
import org.netbeans.modules.j2ee.verification.persistence.BeanAccessType;
import org.openide.text.Line;

import java.util.Set;

/**
 *
 * @author Tomasz Slota
 */
public class ProblemFinderContext {

    private Line.Set lineSet;
    private Resource resource;
    private BaseDocument document;
    private JavaClass mainJavaClass;
    private EntityMappings entityMapping;
    private BeanAccessType beanAccessType = UNDEFINED;

    /**
     * Is it an entity class?
     */
    private boolean isEntityClass = false;

    /**
     * Is it an embeddable class?
     */
    private boolean embeddable = false;

    /**
     * Is it a mapped superclass?
     */
    private boolean mappedSuperclass = false;

    /**
     * Is it an id class?
     */
    private boolean idClass = false;

    /**
     * Is it a stateless session bean?
     */
    private boolean slsb = false;

    /**
     * Is it a stateful session bean?
     */
    private boolean sfsb = false;

    /**
     * Is it a Local Business Interface of an EJB?
     */
    private boolean lbi = false;

    /**
     * Is it a Remote Business Interface of an EJB?
     */
    private boolean rbi = false;

    /**
     * Set of local business interfaces for a SessionBean
     */
    private Set<String> libis;

    /**
     * Set of remote business interfaces for a SessionBean
     */
    private Set<String> rbis;

    /** Creates a new instance of ProblemFinderContext */
    public ProblemFinderContext() {
    }

    public Line.Set getLineSet() {
        return lineSet;
    }

    public void setLineSet(Line.Set lineSet) {
        this.lineSet = lineSet;
    }

    public Resource getResource() {
        return resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public BaseDocument getDocument() {
        return document;
    }

    public void setDocument(BaseDocument document) {
        this.document = document;
    }

    public JavaClass getMainJavaClass() {
        return mainJavaClass;
    }

    public void setMainJavaClass(JavaClass mainJavaClass) {
        this.mainJavaClass = mainJavaClass;
    }

    public BeanAccessType getBeanAccessType() {
        return beanAccessType;
    }

    public void setBeanAccessType(BeanAccessType beanAccessType) {
        this.beanAccessType = beanAccessType;
    }

    public boolean isIsEntityClass() {
        return isEntityClass;
    }

    public void setIsEntityClass(boolean isEntityClass) {
        this.isEntityClass = isEntityClass;
    }

    public boolean isMappedSuperclass() {
        return mappedSuperclass;
    }

    public void setMappedSuperclass(boolean mappedSuperclass) {
        this.mappedSuperclass = mappedSuperclass;
    }

    public EntityMappings getEntityMapping() {
        return entityMapping;
    }

    public void setEntityMapping(EntityMappings entityMapping) {
        this.entityMapping = entityMapping;
    }


    public boolean isEmbeddable() {
            return embeddable;
    }

    public void setEmbeddable(boolean embeddable) {
        this.embeddable = embeddable;
    }

    public boolean isIdClass() {
        return idClass;
    }

    public void setIdClass(boolean idClass) {
        this.idClass = idClass;
    }

    public boolean isSessionBean() {
        return slsb || sfsb;
    }

    public boolean isSLSB() {
        return slsb;
    }

    public void setSLSB(boolean SLSB) {
        this.slsb = SLSB;
    }

    public boolean isSFSB() {
        return sfsb;
    }

    public void setSFSB(boolean SFSB) {
        this.sfsb = SFSB;
    }

    public boolean isLBI() {
        return lbi;
    }

    public void setLBI(boolean LBI) {
        this.lbi = LBI;
    }

    public boolean isRBI() {
        return rbi;
    }

    public void setRBI(boolean RBI) {
        this.rbi = RBI;
    }

    public Set<String> getLBIs() {
        return libis;
    }

    public void setLBIs(Set<String> LBIs) {
        this.libis = LBIs;
    }

    public Set<String> getRBIs() {
        return rbis;
    }

    public void setRBIs(Set<String> RBIs) {
        this.rbis = RBIs;
    }
}
