/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.verification;

import static org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIProblemFinder.RuleNames.*;
import org.netbeans.modules.j2ee.verification.checks.PersistenceUnitNotPresent;
import org.netbeans.modules.j2ee.verification.hints.RemoveElementHint;
import org.netbeans.modules.j2ee.verification.hints.RemoveFinalModifierHint;
import org.netbeans.modules.j2ee.verification.persistence.hints.CreateDefaultConstructor;
import org.netbeans.modules.j2ee.verification.persistence.hints.CreateManyToManyAnnotationHint;
import org.netbeans.modules.j2ee.verification.persistence.hints.CreateManyToOneAnnotationHint;
import org.netbeans.modules.j2ee.verification.persistence.hints.CreateOneToManyAnnotationHint;
import org.netbeans.modules.j2ee.verification.persistence.hints.CreateOneToOneAnnotationHint;
import org.netbeans.modules.j2ee.verification.persistence.hints.CreatePersistenceUnitHint;
import org.netbeans.modules.j2ee.verification.persistence.hints.CreateTemporalAnnotationHint;
import org.netbeans.modules.j2ee.verification.persistence.hints.CreateUnidirManyToOneRelationship;
import org.netbeans.modules.j2ee.verification.persistence.hints.CreateUnidirOneToOneRelationship;
import org.netbeans.modules.j2ee.verification.persistence.hints.ImplementSerializableHint;
import org.netbeans.modules.j2ee.verification.persistence.hints.MakeClassPublicHint;
import org.netbeans.modules.j2ee.verification.ws.checks.AttributeNotAllowedOnInterfaces;
import org.netbeans.modules.j2ee.verification.persistence.hints.CreateIdAnnotationHint;
import org.netbeans.modules.j2ee.verification.persistence.hints.EncapsulateFieldHint;
import org.netbeans.modules.j2ee.verification.persistence.hints.MoveAnnotationsFromSetterToGetter;
import org.netbeans.modules.j2ee.verification.persistence.hints.UnifyFieldAccessHint;
import org.netbeans.modules.j2ee.verification.persistence.hints.UnifyPropertyAccess;
import org.netbeans.modules.j2ee.verification.ws.checks.IllegalWSAnnotationsCombination;
import org.netbeans.modules.j2ee.verification.ws.checks.OnewayAnnotationChecks;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIProblemFinder;
import org.netbeans.modules.j2ee.verification.ws.checks.WSMustHaveAtLeastOneOperation;
import org.netbeans.modules.j2ee.verification.ws.hints.AddNewOperationHint;
import org.netbeans.modules.j2ee.verification.ws.hints.AddWebMethodAnnotationHint;
import org.netbeans.modules.j2ee.verification.ws.hints.RemoveHandlerChainAnnotationHint;
import org.netbeans.modules.j2ee.verification.ejb.EJBAPIProblemFinder;



/**
 * This class is temporary, it will be replaced by config files (the layer?)
 *
 * @author Tomasz Slota
 */
class ProblemFindersRegistry {
    public static final String MISSING_FIELD_ACCESSOR = "missing_field_accessor"; //NOI18N
    
    
    private ProblemFindersRegistry() {
    }
    
    public static void intit(){
        // register problem finders
        
        // -- JSR220 Persistence --
        JEEVerificationAnnotationProvider.registerProblemFinderClass(PersistenceAPIProblemFinder.class.getName());
        JEEVerificationAnnotationProvider.registerProblemFinderClass(PersistenceUnitNotPresent.class.getName());

        // -- JSR220 EJB --
        JEEVerificationAnnotationProvider.registerProblemFinderClass(EJBAPIProblemFinder.class.getName());

        // -- WS 2.0 --
        JEEVerificationAnnotationProvider.registerProblemFinderClass(AttributeNotAllowedOnInterfaces.class.getName());
        JEEVerificationAnnotationProvider.registerProblemFinderClass(OnewayAnnotationChecks.class.getName());
        JEEVerificationAnnotationProvider.registerProblemFinderClass(IllegalWSAnnotationsCombination.class.getName());
        JEEVerificationAnnotationProvider.registerProblemFinderClass(WSMustHaveAtLeastOneOperation.class.getName());

        // register problem solvers
        // -- JSR220 --
        HintsManager.registerHint(IdDefinedInHierarchy, CreateIdAnnotationHint.class.getName());
        HintsManager.registerHint(ConsistentPropertyAccessType, UnifyPropertyAccess.class.getName());
        HintsManager.registerHint(ConsistentFieldAccessType, UnifyFieldAccessHint.class.getName());
        HintsManager.registerHint(MISSING_FIELD_ACCESSOR, EncapsulateFieldHint.class.getName());
        HintsManager.registerHint("setter_methods_annotated_in_entity", MoveAnnotationsFromSetterToGetter.class.getName()); //NOI18N
        HintsManager.registerHint("missing_persistence_unit", CreatePersistenceUnitHint.class.getName()); //NOI18N
        HintsManager.registerHint(NonFinalClass, RemoveFinalModifierHint.class.getName()); //NOI18N
        HintsManager.registerHint("FinalMember", RemoveFinalModifierHint.class.getName()); //NOI18N
        HintsManager.registerHint(SerializableClass, ImplementSerializableHint.class.getName()); //NOI18N
        HintsManager.registerHint(IdClassSerializableClass, ImplementSerializableHint.class.getName()); //NOI18N
        HintsManager.registerHint(HasNoArgConstructor, CreateDefaultConstructor.class.getName());
        HintsManager.registerHint(PublicClass, MakeClassPublicHint.class.getName());
        HintsManager.registerHint(TemporalFieldProperlyAnnotated, CreateTemporalAnnotationHint.class.getName());
        
        HintsManager.registerHint(EntityRelationDefined, CreateUnidirOneToOneRelationship.class.getName());
        HintsManager.registerHint(EntityRelationDefined, CreateOneToOneAnnotationHint.class.getName());
        HintsManager.registerHint(EntityRelationDefined, CreateUnidirManyToOneRelationship.class.getName());
        HintsManager.registerHint(EntityRelationDefined, CreateManyToOneAnnotationHint.class.getName());
        
        HintsManager.registerHint(MVEntityRelationDefined, CreateOneToManyAnnotationHint.class.getName());
        HintsManager.registerHint(MVEntityRelationDefined, CreateManyToManyAnnotationHint.class.getName());
        
        // -- WS 2.0 --
        HintsManager.registerHint("ws_attr_not_allowed_on_intefaces", RemoveElementHint.RemoveAnnotationAttributeHint.class.getName()); //NOI18N
        HintsManager.registerHint("ws_oneway_must_not_have_return_value", RemoveElementHint.RemoveAnnotationHint.class.getName()); //NOI18N
        HintsManager.registerHint("ws_oneway_must_not_have_out_params", RemoveElementHint.RemoveAnnotationHint.class.getName()); //NOI18N
        HintsManager.registerHint("ws_oneway_must_have_corresponding_webmethod", RemoveElementHint.RemoveAnnotationHint.class.getName()); //NOI18N
        HintsManager.registerHint("ws_oneway_must_have_corresponding_webmethod", AddWebMethodAnnotationHint.class.getName()); //NOI18N
        HintsManager.registerHint("ws_oneway_must_not_declare_exceptions", RemoveElementHint.RemoveAnnotationHint.class.getName()); //NOI18N
        HintsManager.registerHint("ws_handler_chain_combined_with_soapmsghndlrs", RemoveElementHint.RemoveAnnotationHint.class.getName()); //NOI18N
        HintsManager.registerHint("ws_handler_chain_combined_with_soapmsghndlrs", RemoveHandlerChainAnnotationHint.class.getName()); //NOI18N
        HintsManager.registerHint("ws_must_have_at_least_one_operation", AddNewOperationHint.class.getName()); //NOI18N
    }
}
