/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification;

import org.netbeans.jmi.javamodel.Element;

/**
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public interface Rule {
    /**
     * A rule is applied to an individual element, called subject.
     *
     * @param subject the element where the rule will be applied.
     * @param ctx     additional information passed onto this test.
     * @return a problem object which represents a violation of a rule. It
     *         returns null, if no violation was detected.
     */
    Problem apply(Element subject, ProblemFinderContext ctx);

    /**
     * Each rule has a unique id. This is used to find out the problem
     * resolver.
     *
     * @return the id of the id of this rule.
     */
    String getId();

    /**
     * How critical is the failure.
     */
    public JEEVerificationProblemMark.Severity getSeverity();

    /**
     * RulesEngine resets each rule before appplying it on a subject
     * so that each invocation can maintain its own state.
     *
     * @see RulesEngine#applyRule(Rule, org.netbeans.jmi.javamodel.Element, ProblemFinderContext)
     */
    void reset();
}
