/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.verification.checks;

import java.io.IOException;
import java.util.MissingResourceException;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceMetadata;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.verification.JEEVerificationContextInfo;
import org.netbeans.modules.j2ee.verification.JEEVerificationProblemMark;
import org.netbeans.modules.j2ee.verification.ProblemFinder;
import org.netbeans.modules.j2ee.verification.ProblemFindingUtils;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIAnnotations;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/**
 *
 * @author Tomasz.Slota@Sun.COM
 */
public class PersistenceUnitNotPresent extends ProblemFinder {
    public void parseDocument() {
        if (!getIsEntityClass()){
            return;
        }
        
        FileObject fo = NbEditorUtilities.getFileObject(getDocument());
        Project project = FileOwnerQuery.getOwner(fo);
        PersistenceScope[] scopes = PersistenceUtils.getPersistenceScopes(project);
        
        for (PersistenceScope scope : scopes){
            if (scope.getClassPath().contains(fo)){
                
                try{
                    FileObject persistenceXML = scope.getPersistenceXml();
                    
                    if (persistenceXML != null){
                        PersistenceUnit pus[] = PersistenceMetadata.getDefault().getRoot(persistenceXML).getPersistenceUnit();
                        
                        if (pus != null && pus.length > 0){
                            // persistence unit found, no warning
                            return;
                        }
                    }
                } catch (IOException e){
                    ErrorManager.getDefault().notify(e);
                }
            }
        }
        
        generateWarning();
    }
    
    private void generateWarning() throws MissingResourceException {
        JavaClass javaClass = getMainJavaClass();
        Element elementToAnnotate = ProblemFindingUtils.findAnnotation(javaClass, PersistenceAPIAnnotations.ENTITY);
        
        if  (elementToAnnotate == null){
            elementToAnnotate = javaClass;
        }
        
        JEEVerificationContextInfo contextInfo = new JEEVerificationContextInfo(javaClass);
        
        JEEVerificationProblemMark problemMark = new JEEVerificationProblemMark("missing_persistence_unit", //NOI18N
                NbBundle.getMessage(this.getClass(), "MSG_MissingPersistenceUnitHint"),
                contextInfo, JEEVerificationProblemMark.Severity.WARNING);
        
        attachProblemMarkToElement(problemMark, elementToAnnotate);
        addProblemMark(problemMark);
    }
}
