/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.common.predicates.clazz;

import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;

import java.util.Collections;

/**
 * Does a class have a constructor that takes no argument? Returns true even
 * when there is no constructor in a class as the compiler generates a default
 * one.
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class HasNoArgConstructorPred extends AbstractPredicate {
    protected boolean evaluate(JavaClass javaClass) {
        Constructor constr = javaClass.getConstructor(Collections.EMPTY_LIST,
                false);
        if (constr == null) {
            // maybe the default constructor is not defined explicitly?
            Element classElements[] = (Element[]) javaClass.getContents()
                    .toArray(new Element[]{});
            for (int i = 0; i < classElements.length; i++) {
                if (classElements[i] instanceof Constructor) {
                    return false; // other constructor exists, but not default
                }
            }
        }
        return true;
    }

}
