/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.ejb.rules.clazz;

import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.ejb.EJBAPIProblemFinder;
import static org.netbeans.modules.j2ee.verification.ProblemFindingUtils.*;

/**
 * Remote business interface of an EJB must not extend EJBObject or
 * EJBLocalObject interface
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class BIDoesNotExtendsEJBObject extends AbstractRule {

    private String messageParam;

    public String getId() {
        return EJBAPIProblemFinder.RuleNames.BIDoesNotExtendsEJBObject;
    }

    protected String getMessageKey() {
        return "MSG_BIExtendsEJBObject"; // NOI18N
    }

    @Override protected boolean isApplicable(
            Element subject, ProblemFinderContext ctx) {
        return (ctx.isRBI() || ctx.isLBI()) &&
                super.isApplicable(subject, ctx);
    }

    @Override public Problem apply(Element subject, ProblemFinderContext ctx) {
        if (isApplicable(subject, ctx)) {
            final String EJB_OBJECT = "javax.ejb.EJBObject"; // NOI18N
            final String EJB_LOCAL_OBJECT = "javax.ejb.EJBLocalObject"; // NOI18N
            final JavaClass javaClass = ctx.getMainJavaClass();
            if (isAssignableFrom(EJB_OBJECT, javaClass)) {
                messageParam = EJB_OBJECT;
                return createProblem(ctx, subject);
            }
            if (isAssignableFrom(EJB_LOCAL_OBJECT, javaClass)) {
                messageParam = EJB_LOCAL_OBJECT;
                return createProblem(ctx, subject);
            }
        }
        return null;
    }

    @Override protected Object[] getMessageParameters() {
        return new Object[]{messageParam};
    }

    @Override public void reset() {
        messageParam = null;
    }
}
