/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.ejb.rules.clazz;

import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.JEEVerificationProblemMark;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.ProblemFindingUtils;
import org.netbeans.modules.j2ee.verification.ejb.EJBAPIProblemFinder;

import java.util.HashSet;
import java.util.Set;

/**
 * In EJB 3.0, it is recommended that a bean class implements its business
 * interface. That way, user does not have to worry about method matching,
 * compiler will take care of that...
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class BeanImplementsBI extends AbstractRule {

    Set<String> unimplementedIFs = new HashSet<String>();

    @Override public JEEVerificationProblemMark.Severity getSeverity(){
        return JEEVerificationProblemMark.Severity.WARNING;
    }

    protected String getMessageKey() {
        return "MSG_BeanImplementsBI"; // NOI18N
    }

    @Override protected Object[] getMessageParameters() {
        StringBuilder sb = new StringBuilder();
        for (String s : unimplementedIFs) {
            sb.append(s).append(" ");
        }
        return new String[]{sb.toString()};
    }

    @Override public void reset() {
        unimplementedIFs.clear();
    }

    public String getId() {
        return EJBAPIProblemFinder.RuleNames.BeanImplementsBI;
    }

    @Override protected boolean isApplicable(
            Element subject, ProblemFinderContext ctx) {
        return (ctx.isSessionBean()) &&
                super.isApplicable(subject, ctx);
    }

    @Override public Problem apply(Element subject, ProblemFinderContext ctx) {
        if (isApplicable(subject, ctx)) {
            Set<String> bis = new HashSet<String>(ctx.getLBIs());
            bis.addAll(ctx.getRBIs());
            JavaClass bean = ctx.getMainJavaClass();
            for (String bi : bis) {
                if (!ProblemFindingUtils.isAssignableFrom(bi, bean)) {
                    unimplementedIFs.add(bi);
                }
            }
            if (!unimplementedIFs.isEmpty()) {
                return createProblem(ctx, subject);
            }
        }
        return null;
    }
}
