/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.ejb.rules.clazz;

import org.netbeans.jmi.javamodel.Element;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.JEEVerificationProblemMark;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.ejb.EJBAPIProblemFinder;
import static org.netbeans.modules.j2ee.verification.ProblemFindingUtils.*;

/**
 * Local business interface should not extend java.rmi.Remote. This is because,
 * java.rmi.Remote is a marker interface used to designate an interface as
 * remote interface. Since a local business interface can not be used as a
 * remote business interface, it is useless for such an interafce to extend
 * java.rmi.Remote.
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class LBIdoesNotExtendRemote extends AbstractRule {
    @Override public JEEVerificationProblemMark.Severity getSeverity(){
        return JEEVerificationProblemMark.Severity.WARNING;
    }

    protected String getMessageKey() {
        return "MSG_LBIdoesNotExtendRemote"; // NOI18N
    }

    public String getId() {
        return EJBAPIProblemFinder.RuleNames.LBIdoesNotExtendRemote;
    }

    @Override protected boolean isApplicable(
            Element subject, ProblemFinderContext ctx) {
        return ctx.isLBI() && super.isApplicable(subject, ctx);
    }

    @Override public Problem apply(Element subject, ProblemFinderContext ctx) {
        if (isApplicable(subject, ctx)) {
            if (isAssignableFrom("java.rmi.Remote", ctx.getMainJavaClass())) { // NOI18N
                return createProblem(ctx, subject);
            }
        }
        return null;
    }
}
