/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.ejb.rules.clazz;

import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.ProblemFindingUtils;
import org.netbeans.modules.j2ee.verification.ejb.EJBAPIProblemFinder;

/**
 * Timers cannot be created for stateful session beans. It may be supported in
 * future version of the spec, but not now.
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class SFSBdoesNotImplementTimedObject extends AbstractRule {

    public String getId() {
        return EJBAPIProblemFinder.RuleNames.SFSBdoesNotImplementTimedObject;
    }

    protected String getMessageKey() {
        return "MSG_SFSBImplementsTimedObject"; // NOI18N
    }

    @Override protected boolean isApplicable(
            Element subject, ProblemFinderContext ctx) {
        return (ctx.isSFSB()) &&
                super.isApplicable(subject, ctx);
    }

    @Override public Problem apply(Element subject, ProblemFinderContext ctx) {
        if (isApplicable(subject, ctx)) {
            JavaClass jc = ctx.getMainJavaClass();
            final String timerIF = "javax.ejb.TimedObject";
            if (ProblemFindingUtils.isAssignableFrom(timerIF, jc)) {
                return createProblem(ctx, subject);
            }
        }
        return null;
    }

}
