/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.ejb.rules.method;

import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ejb.EJBAPIProblemFinder;
import org.netbeans.jmi.javamodel.Element;

import java.util.HashSet;
import java.util.Collection;

/**
 * The invocation semantics of a remote business method is very different
 * from that of a local business method. For this reason, when a session
 * bean has remote as well as local business method, there should not be
 * any method common to both the interfaces. example below is an incorrect
 * use case:
 * <pre>
 *    &#064;Remote public interface I1 { void foo();}
 *    &#064;Local public interface I2 { void foo();}
 *    &#064;Stateless public class Foo implements I1, I2 { ... }
 * </pre>
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class BMnotPartOfRBIandLBI extends AbstractRule {

    //TODO: Not Yet Implemented.

    Collection<String> commonMethods = new HashSet<String>();

    @Override public void reset() {
        commonMethods.clear();
    }

    protected String getMessageKey() {
        return "MSG_BMnotPartOfRBIandLBI"; // NOI18N
    }

    public String getId() {
        return EJBAPIProblemFinder.RuleNames.BMnotPartOfRBIandLBI;
    }

    @Override protected boolean isApplicable(
            Element subject, ProblemFinderContext ctx) {
        // only applicable if bean has both remote as well as local business interface...
        return ctx.isSessionBean() &&
                !ctx.getLBIs().isEmpty() && !ctx.getRBIs().isEmpty() &&
                super.isApplicable(subject, ctx);
    }

    @Override public Problem apply(Element subject, ProblemFinderContext ctx) {
        return super.apply(subject, ctx);
    }
}
