/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.persistence;

import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.verification.*;
import org.netbeans.modules.j2ee.verification.persistence.rules.annotation.*;
import org.netbeans.modules.j2ee.verification.persistence.rules.clazz.*;
import org.netbeans.modules.j2ee.verification.persistence.rules.constructor.*;
import org.netbeans.modules.j2ee.verification.persistence.rules.field.*;
import org.netbeans.modules.j2ee.verification.persistence.rules.member.*;
import org.netbeans.modules.j2ee.verification.persistence.rules.method.*;

/**
 * This problem finder finds out all JSR 220 persistence related problems in
 * Java source. It has a list of {@link Rule} which it applies on the Java
 * source. The rule list is maintained in {@link #rulesRepository} object.
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class PersistenceAPIProblemFinder extends ProblemFinder {

    /**
     * Repository of all the rules applicable to Persistence API.
     */
    private static RulesRepository rulesRepository;

    /**
     * This rule walks through all the elements in the {@link JavaClass} and its
     * children and applies rules that are applicable to each element type.
     *
     * @see RulesEngine
     * @see RulesRepository
     * @see #getProblemMarks()
     */
    public void parseDocument() {
        if (!isApplicable()) {
            return;
        }
        final ProblemFinderContext context = getContext();
        JavaClass javaClass = context.getMainJavaClass();
        RulesEngine.ErrorHandler errorHandler = new RulesEngine.ErrorHandler() {
            public void onError(Problem problem, Rule rule) {
                JEEVerificationProblemMark problemMark =
                        new JEEVerificationProblemMark(rule.getId(),
                                problem.getMessage(),
                                problem.getProblemContext(),
                                rule.getSeverity());
                attachProblemMarkToElement(problemMark,
                        problem.getProblemContext().getElement());
                addProblemMark(problemMark);
            }
        };
        RulesEngine rulesEngine = new RulesEngine(errorHandler, context,
                rulesRepository);

        // now apply rules recurssively
        new TreeWalker(rulesEngine).visitClass(javaClass);
    }

    protected boolean isApplicable() {
        // TODO: We should check to see if file object is part of a persistence
        // project or not.
        return true;
    }

    // temporarily maintain list of all rule names here.
    public static interface RuleNames {
        public static final String HasNoArgConstructor =
                "HasNoArgConstructor"; // NOI18N
        
        public static final String NonFinalClass =
                "NonFinalClass"; // NOI18N
        
        public static final String PublicClass =
                "PublicClass"; // NOI18N
        
        public static final String SerializableClass =
                "SerializableClass"; // NOI18N
        
        public static final String TopLevelClass =
                "TopLevelClass"; // NOI18N
        
        public static final String ProtectedOrPublicConstructor =
                "ProtectedOrPublicConstructor"; // NOI18N
        
        public static final String NonFinalPersistentField =
                "NonFinalPersistentField"; // NOI18N
        
        public static final String NonPublicPersistentField =
                "NonFinalPersistentField"; // NOI18N
        
        public static final String ConsistentFieldAccessType =
                "ConsistentFieldAccessType"; // NOI18N

        public static final String ConsistentPropertyAccessType =
                "ConsistentPropertyAccessType"; // NOI18N

        public static final String GetterVisible =
                "GetterVisible"; // NOI18N
        
        public static final String SetterVisible =
                "SetterVisible"; // NOI18N

        public static final String MatchingGetter =
                "MatchingGetter"; // NOI18N
        
        public static final String MatchingSetter =
                "MatchingSetter"; // NOI18N
        
        public static final String NonFinalMethod =
                "NonFinalMethod"; // NOI18N
        
        public static final String NonGetterNotAnnotated =
                "NonGetterNotAnnotated"; // NOI18N

        public static final String NotBothTransientAndPersistentField =
                "NotBothTransientAndPersistentField"; // NOI18N

        public static final String NotBothTransientAndPersistentMethod =
                "NotBothTransientAndPersistentMethod"; // NOI18N
        
        public static final String TemporalFieldProperlyAnnotated =
                "TemporalFieldProperlyAnnotated"; // NOI18N

        public static final String IdColumnHasNullableSetToFalse =
                "IdColumnHasNullableSetToFalse"; // NOI18N

        public static final String GeneratedIDFieldIsIntegral =
                "GeneratedIDFieldIsIntegral"; // NOI18N

        public static final String GeneratedIDPropertyIsIntegral =
                "GeneratedIDPropertyIsIntegral"; // NOI18N

        public static final String IdClassSerializableClass = 
                "IdClassSerializableClass"; // NOI18N

        public static final String IdClassNoArgConstructorIsPublic =
                "IdClassNoArgConstructorIsPublic"; // NOI18N

        public static final String IdClassOverridesEqualsMethod =
                "IdClassOverridesEqualsMethod"; // NOI18N

        public static final String IdClassOverridesHashCodeMethod =
                "IdClassOverridesHashCodeMethod"; // NOI18N

        public static final String IdDefinedInHierarchy =
                "IdDefinedInHierarchy"; // NOI18N

        public static final String IdDefinedOnceInHierarchy =
                "IdDefinedOnceInHierarchy"; // NOI18N

        public static final String NoIdOnEntitySubclass =
                "NoIdOnEntitySubclass"; // NOI18N

        public static final String MultipleIdsWithIdClass =
                "MultipleIdsWithIdClass"; // NOI18N

        public static final String EitherSimpleIdOrEmbeddedId =
                "EitherSimpleIdOrEmbeddedId"; // NOI18N

        public static final String CorrespondingFieldFoundInIdClass =
                "CorrespondingFieldFoundInIdClass"; // NOI18N

        public static final String CorrespondingGetterFoundInIdClass =
                "CorrespondingGetterFoundInIdClass"; // NOI18N

        public static final String IllegalName =
                "HasIllegalName"; // NOI18N

        public static final String IdClassNotAnInnerClass = 
                "IdClassNotAnInnerClass"; // NOI18N

        public static final String AllFieldsOfIdClassDefinedInEntity =
                "AllFieldsOfIdClassDefinedInEntity"; // NOI18N

        public static final String AllPropertiesOfIdClassDefinedInEntity =
                "AllPropertiesOfIdClassDefinedInEntity"; // NOI18N

        public static final String CorrespondingFieldMappedAsIdInEntity =
                "CorrespondingFieldMappedAsIdInEntity"; // NOI18N

        public static final String CorrespondingGetterMappedAsIdInEntity =
                "CorrespondingGetterMappedAsIdInEntity"; // NOI18N

        public static final String OnlyEntityOrMappedSuperclassCanUseIdClass =
                "OnlyEntityOrMappedSuperclassCanUseIdClass";

        public static final String NoIdClassOnEntitySubclass =
                "NoIdClassOnEntitySubclass"; // NOI18N

        String ValidCollectionType =
                "ValidCollectionType"; // NOI18N

        String InheritanceOnRootEntity =
                "InheritanceOnRootEntity"; // NOI18N

        String GeneratedValueIsId =
                "GeneratedValueIsId"; // NOI18N

        String EmbeddedTargetIsEmbeddable = 
                "EmbeddedTargetIsEmbeddable"; // NOI18N

        String DiscriminatorColumnOnRootEntity =
                "DiscriminatorColumnOnRootEntity";

        String DiscriminatorValueOnConcreteEntity =
                "DiscriminatorValueOnConcreteEntity"; // NOI18N

        String ValidVersionType =
                "ValidVersionType"; // NOI18N

        String ValidEnumerationType =
                "ValidEnumerationType"; // NOI18N

        String ValidTemporalType =
                "ValidTemporalType"; // NOI18N

        String DateTypePKandTemporalType =
                "DateTypePKandTemporalType"; // NOI18N

        String JoinInformationOnOwningSide =
                "JoinInformationOnOwningSide"; // NOI18N

        String ValidBasicType = 
                "ValidBasicType"; // NOI18N

        String EntityNameUnique = 
                "EntityNameUnique"; // NOI18N

        String NamedQueryUnique = 
                "NamedQueryUnique"; // NOI18N

        String NamedNativeQueryUnique =
                "NamedNativeQueryUnique"; // NOI18N

        String EntityRelationDefined = "EntityRelationDefined"; //NOI18N;
        
        String MVEntityRelationDefined = "MVEntityRelationDefined"; //NOI18N;
    }
    
    // Temporarily add all the rules here.
    // TODO: We should read this from an external source like XML.
    static {
        try {
            rulesRepository = new RulesRepository();
            // class level rules
            rulesRepository.registerClazzRule(PublicClass.class.getName());
            rulesRepository.registerClazzRule(NonFinalClass.class.getName());
            rulesRepository.registerClazzRule(TopLevelClass.class.getName());
            rulesRepository.registerClazzRule(
                    HasNoArgConstructor.class.getName());
            rulesRepository.registerClazzRule(
                    SerializableClass.class.getName());
            rulesRepository.registerClazzRule(
                    IdClassSerializableClass.class.getName());
            rulesRepository.registerClazzRule(
                    IdClassOverridesEqualsMethod.class.getName());
            rulesRepository.registerClazzRule(
                    IdClassOverridesHashCodeMethod.class.getName());
            rulesRepository.registerClazzRule(
                    IdClassNotAnInnerClass.class.getName());
            rulesRepository.registerClazzRule(
                    IdDefinedInHierarchy.class.getName());
            rulesRepository.registerClazzRule(
                    IdDefinedOnceInHierarchy.class.getName());
            rulesRepository.registerClazzRule(
                    MultipleIdsWithIdClass.class.getName());
            rulesRepository.registerClazzRule(
                    AllFieldsOfIdClassDefinedInEntity.class.getName());
            rulesRepository.registerClazzRule(
                    AllPropertiesOfIdClassDefinedInEntity.class.getName());
            rulesRepository.registerClazzRule(
                    OnlyEntityOrMappedSuperclassCanUseIdClass.class.getName());
            rulesRepository.registerClazzRule(
                    NoIdClassOnEntitySubclass.class.getName());
            rulesRepository.registerClazzRule(
                    ClassNamedWithJavaPersistenceQLKeyword.class.getName());
            rulesRepository.registerClazzRule(
                    ClassNamedWithSQLKeyword.class.getName());
            
            // constructor level rules
            rulesRepository.registerConstructorRule(
                    ProtectedOrPublicConstructor.class.getName());
            rulesRepository.registerConstructorRule(
                    IdClassNoArgConstructorIsPublic.class.getName());

            // method level rules
            rulesRepository.registerMethodRule(NonFinalMethod.class.getName());
            rulesRepository.registerMethodRule(GetterVisible.class.getName());
            rulesRepository.registerMethodRule(SetterVisible.class.getName());
            rulesRepository.registerMethodRule(
                    ConsistentFieldAccessType.class.getName());
            rulesRepository.registerMethodRule(
                    NonGetterNotAnnotated.class.getName());
            rulesRepository.registerMethodRule(MatchingSetter.class.getName());
            rulesRepository.registerMethodRule(MatchingGetter.class.getName());
            rulesRepository.registerMethodRule(
                    NotBothTransientAndPersistentMethod.class.getName());
            rulesRepository.registerMethodRule(
                    TemporalGetterProperlyAnnotated.class.getName());
            rulesRepository.registerMethodRule(
                    IdColumnHasNullableSetToFalse.class.getName());
            rulesRepository.registerMethodRule(
                    GeneratedIDPropertyIsIntegral.class.getName());
            rulesRepository.registerMethodRule(
                    NoIdOnEntitySubclass.class.getName());
            rulesRepository.registerMethodRule(
                    IdDefinedOnceInHierarchy.class.getName());
            rulesRepository.registerMethodRule(
                    EitherSimpleIdOrEmbeddedId.class.getName());
            rulesRepository.registerMethodRule(
                    CorrespondingGetterFoundInIdClass.class.getName());
            rulesRepository.registerMethodRule(
                    AccessorNamedWithJavaPersistenceQLKeyword.class.getName());
            rulesRepository.registerMethodRule(
                    AccessorNamedWithSQLKeyword.class.getName());
            rulesRepository.registerMethodRule(
                    CorrespondingGetterMappedAsIdInEntity.class.getName());
            rulesRepository.registerMethodRule(
                    ValidCollectionType.class.getName());
            rulesRepository.registerMethodRule(
                    ValidVersionType.class.getName());
            rulesRepository.registerMethodRule(
                    ValidEnumerationType.class.getName());
            rulesRepository.registerMethodRule(
                    ValidTemporalType.class.getName());
            rulesRepository.registerMethodRule(
                    ValidBasicType.class.getName());
            rulesRepository.registerMethodRule(
                    RelationshipDefinedForGetter.class.getName());
            rulesRepository.registerMethodRule(
                    MVRelationshipDefinedForGetter.class.getName());

            // field level rules
            rulesRepository.registerFieldRule(
                    NonFinalPersistentField.class.getName());
            rulesRepository.registerFieldRule(
                    NonPublicPersistentField.class.getName());
            rulesRepository.registerFieldRule(
                    ConsistentPropertyAccessType.class.getName());
            rulesRepository.registerFieldRule(
                    NotBothTransientAndPersistentField.class.getName());
            rulesRepository.registerFieldRule(
                    TemporalFieldProperlyAnnotated.class.getName());
            rulesRepository.registerFieldRule(
                    IdColumnHasNullableSetToFalse.class.getName());
            rulesRepository.registerFieldRule(
                    GeneratedIDFieldIsIntegral.class.getName());
            rulesRepository.registerFieldRule(
                    NoIdOnEntitySubclass.class.getName());
            rulesRepository.registerFieldRule(
                    IdDefinedOnceInHierarchy.class.getName());
            rulesRepository.registerFieldRule(
                    EitherSimpleIdOrEmbeddedId.class.getName());
            rulesRepository.registerFieldRule(
                    CorrespondingFieldFoundInIdClass.class.getName());
            rulesRepository.registerFieldRule(
                    CorrespondingFieldMappedAsIdInEntity.class.getName());
            rulesRepository.registerFieldRule(
                    FieldNamedWithJavaPersistenceQLKeyword.class.getName());
            rulesRepository.registerFieldRule(
                    FieldNamedWithSQLKeyword.class.getName());
            rulesRepository.registerFieldRule(
                    ValidCollectionType.class.getName());
            rulesRepository.registerFieldRule(
                    ValidVersionType.class.getName());
            rulesRepository.registerFieldRule(
                    ValidEnumerationType.class.getName());
            rulesRepository.registerFieldRule(
                    ValidTemporalType.class.getName());
            rulesRepository.registerFieldRule(
                    ValidBasicType.class.getName());
            rulesRepository.registerFieldRule(
                    RelationshipDefinedForField.class.getName());
            rulesRepository.registerFieldRule(
                    MVRelationshipDefinedForField.class.getName());
            

            //register annotation level rules here
            rulesRepository.registerAnnotationRule(
                    InheritanceOnRootEntity.class.getName());
            rulesRepository.registerAnnotationRule(
                    GeneratedValueIsId.class.getName());
            rulesRepository.registerAnnotationRule(
                    EmbeddedTargetIsEmbeddable.class.getName());
            rulesRepository.registerAnnotationRule(
                    DiscriminatorColumnOnRootEntity.class.getName());
            rulesRepository.registerAnnotationRule(
                    DiscriminatorValueOnConcreteEntity.class.getName());
            rulesRepository.registerAnnotationRule(
                    DateTypePKandTemporalType.class.getName());
            rulesRepository.registerAnnotationRule(
                    JoinInformationOnOwningSide.class.getName());
            rulesRepository.registerAnnotationRule(
                    EntityNameUnique.class.getName());
            rulesRepository.registerAnnotationRule(
                    NamedQueryUnique.class.getName());
            rulesRepository.registerAnnotationRule(
                    NamedNativeQueryUnique.class.getName());

        } catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        } catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

}
