/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.verification.persistence.hints;

import java.util.Collections;
import org.netbeans.jmi.javamodel.AnnotableElement;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.modules.editor.hints.spi.ChangeInfo;
import org.netbeans.modules.j2ee.common.JMIGenerationUtil;
import org.netbeans.modules.j2ee.verification.JEEVerificationContextInfo;
import org.netbeans.modules.j2ee.verification.JEEVerificationHint;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIAnnotations;
import org.openide.util.NbBundle;

/**
 *
 * @author Tomasz Slota
 */
public class CreateTemporalAnnotationHint extends JEEVerificationHint {
    
    /** Creates a new instance of CreateTemporalAnnotationHint */
    public CreateTemporalAnnotationHint(JEEVerificationContextInfo problemContext) {
        super(problemContext);
    }

    public String getText() {
        return NbBundle.getMessage(this.getClass(), "LBL_CreateTemporalAnnotationHint");
    }

    public ChangeInfo implement() {
        AnnotableElement elementToAnnotate = (AnnotableElement) getProblemContext().getElement();  
        Annotation ann = JMIGenerationUtil.createAnnotation(elementToAnnotate, PersistenceAPIAnnotations.TEMPORAL, Collections.EMPTY_LIST);
        
        AttributeValue value = JMIGenerationUtil.createAttributeValue(getProblemContext().getJavaClass(),
                "value", "javax.persistence.TemporalType", "DATE"); //NOI18N
        
        ann.getAttributeValues().add(value);
        
        elementToAnnotate.getAnnotations().add(ann);

        return null;
    }

    public int getType() {
        return ERROR;
    }
}
