/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.persistence.predicates.field;

import org.netbeans.jmi.javamodel.Field;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.Entity;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.Transient;
import org.netbeans.modules.j2ee.verification.common.predicates.field.AbstractPredicate;

import java.lang.reflect.Modifier;

import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIHelper;

/**
 * Is this field a Java transient or @Transient annotated field.
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class TransientFieldPred extends AbstractPredicate {
    protected boolean evaluate(Field field) {
        
        if (Modifier.isTransient(field.getModifiers())){
            return true;
        }
        
        Entity e = PersistenceAPIHelper.getEntity(field);
        
        if (e != null && e.getAttributes() != null){
            Transient transientFields[] = e.getAttributes().getTransient();
            
            if (transientFields != null){
                for (Transient tf : transientFields){
                    if (tf.getName().equals(field.getName())){
                        return true;
                    }
                }
            }
        }
        
        return false;
    }
}
