/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.persistence.predicates.member;

import org.netbeans.jmi.javamodel.*;
import org.netbeans.modules.j2ee.verification.JEEVerificationAnnotationProvider;
import org.netbeans.modules.j2ee.verification.common.predicates.member.AbstractPredicate;
import org.netbeans.modules.j2ee.metadata.Constants;
import static org.netbeans.modules.j2ee.verification.ProblemFindingUtils.*;

/**
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class ValidCollectionTypePred extends AbstractPredicate {
    protected boolean evaluate(ClassMember member) {
        Type type = (member instanceof Field) ?
                Field.class.cast(member).getType() :
                Method.class.cast(member).getType();
        if (type instanceof JavaClass) {
            final JavaClass jc = JavaClass.class.cast(type);
            return isAssignableFrom(Constants.COLLECTION, jc) ||
                    isAssignableFrom(Constants.SET, jc) ||
                    isAssignableFrom(Constants.LIST, jc) ||
                    isAssignableFrom(Constants.MAP, jc);
        }
        JEEVerificationAnnotationProvider.tmpDbg("ValidCollectionTypePred: " + // NOI18N
                type + " is not an instanceof JavaClass"); // NOI18N
        return false;
    }
}
