/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.persistence.rules.annotation;

import org.netbeans.jmi.javamodel.*;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.JEEVerificationProblemMark;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIProblemFinder;
import org.netbeans.modules.j2ee.verification.persistence.predicates.annotation.TemporalPred;
import org.netbeans.modules.j2ee.verification.persistence.predicates.member.AnnotatedAsIdPred;

import javax.jmi.reflect.RefFeatured;
import java.util.Arrays;
import java.util.List;

import static org.netbeans.modules.j2ee.verification.JEEVerificationAnnotationProvider.tmpDbg;

/**
 * If java.util.date is used as PK, then Tempral type should be specified as
 * DATE
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class DateTypePKandTemporalType extends AbstractRule {

    public DateTypePKandTemporalType() {
        super(null, Arrays.asList(new TemporalPred()));
    }

    protected String getMessageKey() {
        return "MSG_DateTypePKandTemporalType"; // NOI18N
    }

    public String getId() {
        return PersistenceAPIProblemFinder.RuleNames.DateTypePKandTemporalType;
    }

    @Override protected boolean isApplicable(
            Element subject, ProblemFinderContext ctx) {
        return (ctx.isIsEntityClass() || ctx.isMappedSuperclass()) &&
                super.isApplicable(subject, ctx);
    }

    @Override public Problem apply(Element subject, ProblemFinderContext ctx) {
        if (isApplicable(subject, ctx)) {
            Type type = null;
            boolean annotatedAsId = false;
            Annotation annotation = Annotation.class.cast(subject);
            final RefFeatured obj = annotation.refImmediateComposite();
            if (obj instanceof Field) {
                type = Field.class.cast(obj).getType();
                annotatedAsId = new AnnotatedAsIdPred().evaluate(obj);
            } else if (obj instanceof Method) {
                type = Method.class.cast(obj).getType();
                annotatedAsId = new AnnotatedAsIdPred().evaluate(obj);
            }
            if (annotatedAsId && type instanceof JavaClass) {
                JavaClass jc = JavaClass.class.cast(type);
                if ("java.util.Date".equals(jc.getName())) { //NOI18N
                    if (annotation.isValid()) {
                        List attributeValues = annotation.getAttributeValues();
                        if (attributeValues.size() == 1) {
                            AttributeValue attributeValue =
                                    (AttributeValue) attributeValues.get(0);
                            InitialValue value = attributeValue.getValue();
                            tmpDbg(value.toString());
                            if (value instanceof VariableAccess) {
                                String s = VariableAccess.class.cast(value).
                                        getName();
                                if (!("javax.persistence.TemporalType.DATE".equals(s) || // NOI18N
                                        "TemporalType.DATE".equals(s) || // NOI18N
                                        "DATE".equals(s))) { // NOI18N
                                    return createProblem(ctx, subject);
                                }
                            }
                        }
                    }
                }
            }
        }
        return null;
    }

    @Override public JEEVerificationProblemMark.Severity getSeverity(){
        return JEEVerificationProblemMark.Severity.WARNING;
    }
}
