/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.persistence.rules.annotation;

import org.netbeans.jmi.javamodel.*;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.Entity;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.EntityMappings;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIProblemFinder;

import javax.jmi.reflect.RefFeatured;
import java.util.List;

/**
 * Entity name mustbe unique in a persistence unit.
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class EntityNameUnique extends AbstractRule {

    String entityClassName;

    protected String getMessageKey() {
        return "MSG_EntityNameUnique"; // NOI18N
    }

    @Override protected Object[] getMessageParameters() {
        return new Object[]{entityClassName};
    }

    @Override public void reset() {
        entityClassName = null;
    }

    public String getId() {
        return PersistenceAPIProblemFinder.RuleNames.EntityNameUnique;
    }

    @Override protected boolean isApplicable(
            Element subject, ProblemFinderContext ctx) {
        return (ctx.isIsEntityClass()) &&
                super.isApplicable(subject, ctx);
    }

    @Override public Problem apply(Element subject, ProblemFinderContext ctx) {
        if (isApplicable(subject, ctx)) {
            Annotation annotation = Annotation.class.cast(subject);
            String entityName = getNameOfEntity(annotation);
            int count = 0;
            final EntityMappings mapping = ctx.getEntityMapping();
            if (entityName != null && mapping != null) {
                for (Entity e : mapping.getEntity()) {
                    if (entityName.equals(e.getName())) count++;
                    if (count > 1) {
                        entityClassName = e.getClass2();
                        return createProblem(ctx, subject);
                    }
                }
            }
        }
        return null;
    }

    private static String getNameOfEntity(Annotation entity) {
        final RefFeatured obj = entity.refImmediateComposite();
        if (obj instanceof JavaClass) {
            for (AttributeValue attrValue :
                    (List<AttributeValue>) entity.getAttributeValues()) {
                if ("name".equals(attrValue.getName())) {
                    InitialValue value = attrValue.getValue();
                    if (value instanceof StringLiteral) {
                        return StringLiteral.class.cast(value).getValue();
                    }
                }
            }
            return JavaClass.class.cast(obj).getSimpleName();
        }
        return null; // this will happen for extreme error condition
    }
}
