/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.persistence.rules.annotation;

import org.netbeans.jmi.javamodel.*;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIProblemFinder;
import org.netbeans.modules.j2ee.verification.persistence.predicates.annotation.JoinPred;

import javax.jmi.reflect.RefFeatured;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import static java.util.Arrays.*;
import static org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIAnnotations.*;
import static org.netbeans.modules.j2ee.verification.ProblemFindingUtils.*;

/**
 * JoinColumn(s) and JoinTable indformation must be specified only on owning
 * side of a relationship.
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class JoinInformationOnOwningSide extends AbstractRule {

    public JoinInformationOnOwningSide() {
        super(null, asList(new JoinPred()));
    }

    protected String getMessageKey() {
        return "MSG_JoinInformationOnOwningSide"; // NOI18N
    }

    public String getId() {
        return PersistenceAPIProblemFinder.RuleNames.JoinInformationOnOwningSide;
    }

    @Override protected boolean isApplicable(
            Element subject, ProblemFinderContext ctx) {
        return (ctx.isIsEntityClass() || ctx.isMappedSuperclass()) &&
                super.isApplicable(subject, ctx);
    }

    @Override public Problem apply(Element subject, ProblemFinderContext ctx) {
        if (isApplicable(subject, ctx)) {
            Annotation annotation = Annotation.class.cast(subject);
            final RefFeatured obj = annotation.refImmediateComposite();
            if (obj instanceof ClassMember) {
                Set<String> relAnnotationNames = new TreeSet<String>(asList(
                        ONE_TO_MANY, ONE_TO_ONE, MANY_TO_MANY, MANY_TO_ONE));
                Annotation relAnnotation = findFirstAnnotationFromGivenSet(
                        ClassMember.class.cast(obj), relAnnotationNames);
                if (relAnnotation != null && isMappedBySpecified(relAnnotation)) {
                    return createProblem(ctx, subject);
                }
            }
        }
        return null;
    }

    private static boolean isMappedBySpecified(Annotation a) {
        for (AttributeValue attrValue :
                (List<AttributeValue>) a.getAttributeValues()) {
            if ("mappedBy".equals(attrValue.getName())) { // NOI18N
                InitialValue value = attrValue.getValue();
                if (value instanceof StringLiteral) {
                    return StringLiteral.class.cast(value).getValue().length() !=
                            0;
                }
            }
        }
        return false;
    }

}
