/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.persistence.rules.annotation;

import static org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIAnnotations.NAMED_QUERY;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.Entity;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.EntityMappings;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.NamedQuery;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIProblemFinder;

import java.util.List;

/**
 * NamedQuery name must be unique in a persistence unit.
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class NamedQueryUnique extends AbstractRule {

    protected String getMessageKey() {
        return "MSG_NamedQueryUnique"; // NOI18N
    }

    public String getId() {
        return PersistenceAPIProblemFinder.RuleNames.NamedQueryUnique;
    }

    @Override protected boolean isApplicable(
            Element subject, ProblemFinderContext ctx) {
        if (ctx.isIsEntityClass()) {
            Annotation annotation = Annotation.class.cast(subject);
            Type type = annotation.getType();
            if (type != null) {
                if(NAMED_QUERY.equals(type.getName())) { // NOI18N
                    return super.isApplicable(subject, ctx);
                }
            }
        }
        return false;
    }

    @Override public Problem apply(Element subject, ProblemFinderContext ctx) {
        if (isApplicable(subject, ctx)) {
            Annotation annotation = Annotation.class.cast(subject);
            String queryName = getNameOfQuery(annotation);
            int count = 0;
            final EntityMappings entityMapping = ctx.getEntityMapping();
            if (queryName != null && entityMapping != null) {
                for (NamedQuery nq : entityMapping.getNamedQuery()) {
                    if (queryName.equals(nq.getName())) count++;
                    if (count > 1) {
                        return createProblem(ctx, subject);
                    }
                }
                for (Entity e : entityMapping.getEntity()) {
                    for (NamedQuery nq : e.getNamedQuery()) {
                        if (queryName.equals(nq.getName())) count++;
                        if (count > 1) {
                            return createProblem(ctx, subject);
                        }
                    }
                }
            }
        }
        return null;
    }

    private static String getNameOfQuery(Annotation entity) {
        for (AttributeValue attrValue :
                (List<AttributeValue>) entity.getAttributeValues()) {
            if ("name".equals(attrValue.getName())) { // NOI18N
                InitialValue value = attrValue.getValue();
                if (value instanceof StringLiteral) {
                    return StringLiteral.class.cast(value).getValue();
                }
            }
        }
        return null; // this will happen for extreme error condition
    }
}
