/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.persistence.rules.clazz;

import org.netbeans.jmi.javamodel.Element;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIProblemFinder;
import org.netbeans.modules.j2ee.verification.persistence.BeanAccessType;

/**
 * An entity hierarchy must have an Id. It could be a simple Id, cmposite Id or
 * embedded Id. In case of simple and composite id, it must have atleast one
 * field or property annotated as Id, where as in case of emdebedded id, it must
 * have a field or property annotated as Embedded.
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class IdDefinedInHierarchy extends AbstractRule {

    public String getId() {
        return PersistenceAPIProblemFinder.RuleNames.IdDefinedInHierarchy;
    }

    protected String getMessageKey() {
        return "MSG_NoIdDefinedInHierarchy"; // NOI18N
    }

    @Override protected boolean isApplicable(
            Element subject, ProblemFinderContext ctx) {
        return (ctx.isIsEntityClass()) &&
                super.isApplicable(subject, ctx);
    }

    @Override public Problem apply(Element subject, ProblemFinderContext ctx) {
        if (isApplicable(subject, ctx)) {
            // We calculate the access type based on presence of @Id or @EmbeddedId
            // in the superclass chain. So it is enough to test for UNDEFINED
            // to report a problem.
            if(ctx.getBeanAccessType() == BeanAccessType.UNDEFINED) {
                return createProblem(ctx, subject);
            }
//            JavaClass javaClass = JavaClass.class.cast(subject);
//            boolean idDefined = isAnyMemberAnnotatedAsIdOrEmbeddedId(javaClass);
//            if (!idDefined) {
//                for (JavaClass nextClass = javaClass.getSuperClass();
//                     !nextClass.getName().equals(Constants.OBJECT);
//                     nextClass = nextClass.getSuperClass()) {
//                    idDefined =
//                            isAnyMemberAnnotatedAsIdOrEmbeddedId(nextClass);
//                    if (idDefined) {
//                        break;
//                    }
//                }
//            }
//            if (!idDefined) {
//                return createProblem(ctx, subject);
//            }
        }
        return null;
    }
}
