/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.persistence.rules.field;

import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIHelper;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIProblemFinder;
import org.netbeans.modules.j2ee.verification.persistence.BeanAccessType;
import org.netbeans.modules.j2ee.verification.persistence.predicates.clazz.AnnotatedAsIdClassPred;
import org.netbeans.modules.j2ee.verification.persistence.predicates.member.AnnotatedAsIdPred;

import java.util.Arrays;

/**
 * all Ids found in Entity or MappedSuperclass must be also present in IdClass.
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class CorrespondingFieldFoundInIdClass extends AbstractRule {
    public CorrespondingFieldFoundInIdClass() {
        super(null, Arrays.asList(new AnnotatedAsIdPred()));
    }

    public String getId() {
        return PersistenceAPIProblemFinder.RuleNames.CorrespondingFieldFoundInIdClass;
    }

    protected String getMessageKey() {
        return "MSG_FieldNotFoundInIdClass"; // NOI18N
    }

    @Override protected boolean isApplicable(
            Element subject, ProblemFinderContext ctx) {
        return (ctx.isIsEntityClass() || ctx.isMappedSuperclass()) &&
                ctx.getBeanAccessType() == BeanAccessType.FIELD &&
                new AnnotatedAsIdClassPred().evaluate(ctx.getMainJavaClass()) &&
                super.isApplicable(subject, ctx);
    }

    @Override public Problem apply(Element subject, ProblemFinderContext ctx) {
        if (isApplicable(subject, ctx)) {
            JavaClass javaClass = ctx.getMainJavaClass();
            JavaClass idClass = PersistenceAPIHelper.getIdClass(javaClass);
            if (idClass != null) {
                // See, we don't search in super class of idClass
                final Field field = Field.class.cast(subject);
                Field idField = idClass.getField(field.getName(), false);
                if (idField == null || idField.getType() != field.getType()) {
                    return createProblem(ctx, subject);
                }
            }
        }
        return null;
    }
}
