/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.persistence.rules.member;

import org.netbeans.jmi.javamodel.*;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIProblemFinder;
import org.netbeans.modules.j2ee.verification.persistence.predicates.member.AnnotatedAsColumnPred;
import org.netbeans.modules.j2ee.verification.persistence.predicates.member.AnnotatedAsIdPred;
import org.netbeans.modules.javacore.jmiimpl.javamodel.BooleanLiteralImpl;

import java.util.Arrays;
import java.util.List;

import static org.netbeans.modules.j2ee.verification.JEEVerificationAnnotationProvider.tmpDbg;
import static org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIAnnotations.*;
import static org.netbeans.modules.j2ee.verification.ProblemFindingUtils.*;

/**
 * The Id column must not be nullable.
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class IdColumnHasNullableSetToFalse extends AbstractRule {

    /**
     * Creates a new instance
     */
    public IdColumnHasNullableSetToFalse() {
        super(null, // we override apply()
                Arrays.asList(new AnnotatedAsIdPred(),
                        new AnnotatedAsColumnPred()));
    }

    @Override public Problem apply(Element subject, ProblemFinderContext ctx) {
        if (isApplicable(subject, ctx)) {
            final AnnotableElement ae = AnnotableElement.class.cast(subject);
            Annotation column = findAnnotation(ae, COLUMN);
            for (AttributeValue attr :
                    (List<AttributeValue>) column.getAttributeValues()) {
                if (NULLABLE.equals(attr.getName())) { // nullable is explicitly specified
                    final InitialValue value = attr.getValue();
                    tmpDbg("nullable=" + value); // NOI18N
                    try {
                        if (BooleanLiteralImpl.class.cast(value).isValue()) {
                            return createProblem(ctx, value);
                        }
                    } catch (ClassCastException cce) {
                        // this happens when user says nullable=neither-true-nor-false
                    }
                }
            }
        }
        return null;
    }

    protected String getMessageKey() {
        return "MSG_IdColumnHasNullableSetToTrue"; //NOI18N
    }

    public String getId() {
        return PersistenceAPIProblemFinder.RuleNames.IdColumnHasNullableSetToFalse;
    }

    @Override protected boolean isApplicable(
            Element subject, ProblemFinderContext ctx) {
        return (ctx.isIsEntityClass() || ctx.isMappedSuperclass()) &&
                super.isApplicable(subject, ctx);
    }
}
