/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.persistence.rules.member;

import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIProblemFinder;
import org.netbeans.modules.j2ee.metadata.Constants;
import org.netbeans.modules.j2ee.verification.persistence.predicates.member.AnnotatedAsIdOrEmbeddedIdPred;
import static org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIHelper.*;

import java.util.Arrays;

/**
 * Id must be defined only once in an entity hierarchy.
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class IdDefinedOnceInHierarchy extends AbstractRule {

    private String superClassThatDefinesId;

    public IdDefinedOnceInHierarchy() {
        super(null, // we override apply
                Arrays.asList(new AnnotatedAsIdOrEmbeddedIdPred()));
    }

    public String getId() {
        return PersistenceAPIProblemFinder.RuleNames.IdDefinedOnceInHierarchy;
    }

    protected String getMessageKey() {
        return "MSG_SuperClassAlreadyHasId"; // NOI18N
    }

    @Override protected Object[] getMessageParameters() {
        Object[] result = {superClassThatDefinesId};
        return result;
    }

    @Override protected boolean isApplicable(
            Element subject, ProblemFinderContext ctx) {
        // only applicable for mapped-superclass because
        // we have a rule that NoIdInEntitySubclass for entities.
        return ctx.isMappedSuperclass() &&
                super.isApplicable(subject, ctx);
    }

    @Override public Problem apply(Element subject, ProblemFinderContext ctx) {
        if (isApplicable(subject, ctx)) {
            JavaClass javaClass = ctx.getMainJavaClass();
            boolean idAlreadyDefined = false;
            for (JavaClass nextClass = javaClass.getSuperClass();
                 !nextClass.getName().equals(Constants.OBJECT);
                 nextClass = nextClass.getSuperClass()) {
                idAlreadyDefined =
                        isAnyMemberAnnotatedAsIdOrEmbeddedId(nextClass);
                if (idAlreadyDefined) {
                    superClassThatDefinesId = nextClass.getName();
                    return createProblem(ctx, subject);
                }
            }
        }
        return null;
    }

    @Override public void reset() {
        superClassThatDefinesId = null;
    }
}
