/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.persistence.rules.member;

import org.netbeans.jmi.javamodel.*;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIHelper;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIProblemFinder;
import org.netbeans.modules.j2ee.verification.persistence.predicates.member.AnnotatedAsBasicPred;

import java.util.Arrays;

import static org.netbeans.modules.j2ee.verification.ProblemFindingUtils.*;
import static org.netbeans.modules.j2ee.metadata.Constants.*;

/**
 * The following types are supported for Basic properties: Java primitive types,
 * wrapper of primitive types, java.lang.String, java.math.BigInteger,
 * java.math.BigDecimal, java.util.Date, java.util.Calendar, java.sql.Date,
 * java.sql.Time, java.sql.TimeStamp, byte[], Byte[], char[], Character[],
 * enums, and any other type that implements Serializable.
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class ValidBasicType extends AbstractRule {
    public ValidBasicType() {
        super(null, // we override apply
                Arrays.asList(new AnnotatedAsBasicPred()));
    }

    public String getId() {
        return PersistenceAPIProblemFinder.RuleNames.ValidBasicType;
    }

    protected String getMessageKey() {
        return "MSG_ValidBasicType"; // NOI18N
    }

    @Override protected boolean isApplicable(
            Element subject, ProblemFinderContext ctx) {
        return (ctx.isIsEntityClass() || ctx.isMappedSuperclass()) &&
                super.isApplicable(subject, ctx);
    }

    @Override public Problem apply(Element subject, ProblemFinderContext ctx) {
        if (isApplicable(subject, ctx)) {
            Type type = null;
            if (subject instanceof Field) {
                type = Field.class.cast(subject).getType();
            } else if (subject instanceof Method) {
                type = Method.class.cast(subject).getType();
            }
            if (!(PersistenceAPIHelper.isFixedBasicType(type))) {
                if (type instanceof JavaClass) {
                    JavaClass jc = JavaClass.class.cast(type);
                    if (!(isAssignableFrom(SERIALIZABLE, jc) ||
                            isAssignableFrom(ENUM, jc))) {
                        return createProblem(ctx, subject);
                    }
                }
            }
        }
        return null;
    }
}
