/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.persistence.rules.member;

import org.netbeans.jmi.javamodel.*;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIProblemFinder;
import org.netbeans.modules.j2ee.verification.persistence.predicates.member.IsAnnotatedAsTemporalPred;

import java.util.Arrays;

/**
 * Temporal annotation may only be used for java.util.Date and
 * java.util.Calendar types.
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class ValidTemporalType extends AbstractRule {
    public ValidTemporalType() {
        super(null, // we override apply
                Arrays.asList(new IsAnnotatedAsTemporalPred()));
    }

    public String getId() {
        return PersistenceAPIProblemFinder.RuleNames.ValidTemporalType;
    }

    protected String getMessageKey() {
        return "MSG_ValidTemporalType"; // NOI18N
    }

    @Override protected boolean isApplicable(
            Element subject, ProblemFinderContext ctx) {
        return (ctx.isIsEntityClass() || ctx.isMappedSuperclass()) &&
                super.isApplicable(subject, ctx);
    }

    @Override public Problem apply(Element subject, ProblemFinderContext ctx) {
        if (isApplicable(subject, ctx)) {
            Type type = null;
            if (subject instanceof Field) {
                type = Field.class.cast(subject).getType();
            } else if (subject instanceof Method) {
                type = Method.class.cast(subject).getType();
            }
            if (type instanceof JavaClass) {
                JavaClass jc = JavaClass.class.cast(type);
                final String name = jc.getName();
                if (!("java.util.Date".equals(name) || // NOI18N
                        "java.util.Calendar".equals(name))) { // NOI18N
                    return createProblem(ctx, subject);
                }
            }
        }
        return null;
    }
}
