/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.verification.persistence.rules.method;

import java.util.Arrays;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.persistence.BeanAccessType;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIProblemFinder;
import org.netbeans.modules.j2ee.verification.persistence.predicates.member.IsAnnotatedAsTemporalPred;
import org.netbeans.modules.j2ee.verification.persistence.predicates.member.IsTemporalTypePred;
import org.netbeans.modules.j2ee.verification.persistence.predicates.method.GetterPred;
import org.netbeans.modules.j2ee.verification.persistence.predicates.method.NotAnnotatedAsTransientPred;

/**
 * 
 *
 * @author Tomasz Slota
 */
public class TemporalGetterProperlyAnnotated extends AbstractRule  {
    
    /** Creates a new instance of TemporalFieldProperlyAnnotated */
    public TemporalGetterProperlyAnnotated() {
        super(new IsAnnotatedAsTemporalPred(), Arrays.asList(new IsTemporalTypePred(),
                new GetterPred(), new NotAnnotatedAsTransientPred()));
    }

    protected String getMessageKey() {
        return "MSG_TemporalFieldNotAnnotatedProperly"; //NOI18N
    }

    public String getId() {
        return PersistenceAPIProblemFinder.RuleNames.TemporalFieldProperlyAnnotated;
    }
    
    @Override protected boolean isApplicable(Element subject, ProblemFinderContext ctx) {
        return ctx.getBeanAccessType() == BeanAccessType.PROPERTY && super.isApplicable(subject, ctx);
    }
}
