/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.verification.ws.checks;

import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.verification.JEEVerificationContextInfo;
import org.netbeans.modules.j2ee.verification.JEEVerificationProblemMark;
import org.netbeans.modules.j2ee.verification.ProblemFinder;
import org.netbeans.modules.j2ee.verification.ProblemFindingUtils;
import org.openide.util.NbBundle;

/**
 *
 * @author Tomasz Slota
 */
public class IllegalWSAnnotationsCombination extends ProblemFinder {

    public void parseDocument() {
        JavaClass javaClass = getMainJavaClass();
        
        Annotation wsAnnotation = ProblemFindingUtils.findAnnotation(javaClass, WSAnnotations.WEB_SERVICE);
        
        if (wsAnnotation != null){
            Annotation annHandlerChain = ProblemFindingUtils.findAnnotation(javaClass, WSAnnotations.HANDLER_CHAIN);
            
            if (annHandlerChain != null){
                Annotation annMsgHandlers = ProblemFindingUtils.findAnnotation(javaClass, WSAnnotations.SOAP_MESSAGE_HANDLERS);
                
                if (annMsgHandlers != null){
                    JEEVerificationContextInfo problemContext = new JEEVerificationContextInfo(javaClass);
                    problemContext.setElement(annMsgHandlers);

                    JEEVerificationProblemMark problemMark = new JEEVerificationProblemMark("ws_handler_chain_combined_with_soapmsghndlrs", //NOI18N
                        NbBundle.getMessage(this.getClass(), "MSG_HandlerChainCannotBeCombinedWithSOAPMsgHndlrs"),
                        problemContext);
                    
                    attachProblemMarkToElement(problemMark, wsAnnotation);
                    addProblemMark(problemMark);
                }
            }
        }
    }
    
}
