/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.verification.ws.checks;

import java.util.Iterator;
import java.util.MissingResourceException;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.modules.j2ee.verification.JEEVerificationContextInfo;
import org.netbeans.modules.j2ee.verification.JEEVerificationProblemMark;
import org.netbeans.modules.j2ee.verification.ProblemFinder;
import org.netbeans.modules.j2ee.verification.ProblemFindingUtils;
import org.openide.util.NbBundle;

/**
 *
 * @author Tomasz Slota
 */
public class OnewayAnnotationChecks extends ProblemFinder {
    
    public void parseDocument() {
        JavaClass javaClass = getMainJavaClass();
        
        if (ProblemFindingUtils.findAnnotation(javaClass, WSAnnotations.WEB_SERVICE) == null){
            return; // not a WS
        }
        
        Element members[] = (Element[]) javaClass.getContents().toArray(new Element[0]);
        
        for (int i = 0; i < members.length; i++) {
            if (members[i] instanceof Method){
                Method method = (Method)members[i];
                
                Annotation oneWayAnn = ProblemFindingUtils.findAnnotation(method, WSAnnotations.ONE_WAY);
                
                if (oneWayAnn != null){
                    checkIfIsAWebMethod(javaClass, method, oneWayAnn);
                    checkIfHasAReturnValue(method, javaClass, oneWayAnn);
                    checkIfHasNoOutParams(javaClass, method, oneWayAnn);
                    checkIfDeclaresNoExceptions(javaClass, method, oneWayAnn);
                }
            }
        }
    }
    
    private void checkIfHasNoOutParams(final JavaClass javaClass, final Method method, final Annotation oneWayAnn) throws MissingResourceException {
        
        for (Iterator it = method.getParameters().iterator(); it.hasNext();){
            Parameter param = (Parameter)it.next();
            
            Annotation annWebParam = ProblemFindingUtils.findAnnotation(param, WSAnnotations.WEB_PARAM);
            
            if (annWebParam != null){
                for (Iterator it2 = annWebParam.getAttributeValues().iterator(); it2.hasNext();){
                    AttributeValue attr = (AttributeValue) it2.next();
                    
                    if ("mode".equals(attr.getName())){ //NOI18N
                        String modeValue = ((NamedElement)attr.getValue()).getName();
                        
                        if ("OUT".equals(modeValue) || "INOUT".equals(modeValue)){ //NOI18N
                            JEEVerificationContextInfo problemContext = new JEEVerificationContextInfo(javaClass);
                            problemContext.setElement(oneWayAnn);
                            
                            JEEVerificationProblemMark problemMark = new JEEVerificationProblemMark("ws_oneway_must_not_have_out_params", //NOI18N
                                    NbBundle.getMessage(this.getClass(), "MSG_OnewayMethodMustNotHaveOutParams"), problemContext);
                            
                            attachProblemMarkToElement(problemMark, oneWayAnn);
                            addProblemMark(problemMark);
                        }
                    }
                }
            }
        }
    }

    private void checkIfHasAReturnValue(final Method method, final JavaClass javaClass, final Annotation oneWayAnn) throws MissingResourceException {
        
        if (method.getType() == null || !"void".equals(method.getType().getName())){ //NOI18N
            JEEVerificationContextInfo problemContext = new JEEVerificationContextInfo(javaClass);
            problemContext.setElement(oneWayAnn);
            
            JEEVerificationProblemMark problemMark = new JEEVerificationProblemMark("ws_oneway_must_not_have_return_value", //NOI18N
                    NbBundle.getMessage(this.getClass(), "MSG_OnewayMethodMustNotHaveReturnvalue"), problemContext);
            
            attachProblemMarkToElement(problemMark, oneWayAnn);
            addProblemMark(problemMark);
        }
    }

    private void checkIfIsAWebMethod(final JavaClass javaClass, final Method method, final Annotation oneWayAnn) throws MissingResourceException {
        if (ProblemFindingUtils.findAnnotation(method, WSAnnotations.WEB_METHOD) == null){
            JEEVerificationContextInfo problemContext = new JEEVerificationContextInfo(javaClass);
            problemContext.setElement(oneWayAnn);
            
            JEEVerificationProblemMark problemMark = new JEEVerificationProblemMark("ws_oneway_must_have_corresponding_webmethod", //NOI18N
                    NbBundle.getMessage(this.getClass(), "MSG_OnewayMustHaveCorrespondingWebmethod"), problemContext);
            
            attachProblemMarkToElement(problemMark, oneWayAnn);
            addProblemMark(problemMark);
        }
    }

    private void checkIfDeclaresNoExceptions(JavaClass javaClass, Method method, Annotation oneWayAnn) {
        if (method.getExceptions() != null && method.getExceptions().size() > 0){
                        JEEVerificationContextInfo problemContext = new JEEVerificationContextInfo(javaClass);
            problemContext.setElement(oneWayAnn);
            
            JEEVerificationProblemMark problemMark = new JEEVerificationProblemMark("ws_oneway_must_not_declare_exceptions", //NOI18N
                    NbBundle.getMessage(this.getClass(), "MSG_OnewayMustNotDeclareExceptions"), problemContext);
            
            attachProblemMarkToElement(problemMark, oneWayAnn);
            addProblemMark(problemMark);
        }
    }
}
