/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.verification.ws.checks;

import java.lang.reflect.Modifier;
import java.util.List;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.modules.j2ee.verification.JEEVerificationContextInfo;
import org.netbeans.modules.j2ee.verification.JEEVerificationProblemMark;
import org.netbeans.modules.j2ee.verification.ProblemFinder;
import org.netbeans.modules.j2ee.verification.ProblemFindingUtils;
import org.openide.util.NbBundle;

/**
 * Each WebService must contain at least one operation
 *
 * @author Tomasz.Slota@Sun.COM
 */
public class WSMustHaveAtLeastOneOperation extends ProblemFinder{
    public void parseDocument() {
        JavaClass javaClass = getMainJavaClass();
        Annotation annWS = ProblemFindingUtils.findAnnotation(javaClass, WSAnnotations.WEB_SERVICE);
        
        if (annWS != null){ // Is it WS class/interface?
            
            for (Element e : (List<Element>)javaClass.getContents()){
                if (e instanceof Method && isOperation((Method)e)){
                    // OK, there is at least one operation
                    return;
                }
            }
            
            // no method was explicitly set as operation,
            // any public method except those inherited from
            // java.lang.Object is considered an operation
            // web_services_metadata-2_0-mrel-spec.pdf#3.1 (JSR 181)
            
            if (hasPublicMethod(javaClass)){
                return;
            }
            
            // no operation found, report problem
            
            JEEVerificationContextInfo problemContext = new JEEVerificationContextInfo(javaClass);
            JEEVerificationProblemMark problemMark = new JEEVerificationProblemMark("ws_must_have_at_least_one_operation", //NOI18N
                    NbBundle.getMessage(this.getClass(), "MSG_WSMustHaveAtLeastOneOperation"), problemContext);
            
            attachProblemMarkToElement(problemMark, javaClass);
            addProblemMark(problemMark);
        }
    }
    
    private boolean isOperation(Method method) {
        Annotation annWebMethod = ProblemFindingUtils.findAnnotation(method, WSAnnotations.WEB_METHOD);
        return annWebMethod != null;
    }
    
    private boolean hasPublicMethod(JavaClass javaClass){
        if ("java.lang.Object".equals(javaClass.getName())){ //NOI18N
            return false;
        }
        
        for (Element e : (List<Element>)javaClass.getContents()){
            if (e instanceof Method && Modifier.isPublic(((Method)e).getModifiers())){
                // found public method
                return true;
            }
        }
        
        return hasPublicMethod(javaClass.getSuperClass());
    }
    
}
