/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.verification.test;

import java.io.File;
import java.util.Collection;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.editor.BaseDocument;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.ide.ProjectSupport;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.RequestProcessor;

/**
 *
 * @author Tomasz.Slota@Sun.COM
 */
public abstract class JEEVerificationChecksTestBase extends NbTestCase {
    private FileObject sourcesDir;
    private static final int PAUSE = 5000;
    
    public JEEVerificationChecksTestBase(String testName) {
        super(testName);
    }

    @Override protected void setUp() throws Exception {
        ProjectSupport.waitScanFinished();
        Project project = ProjectManager.getDefault().findProject(FileUtil.toFileObject(new File(getDataDir(), "TestProject")));
        FileObject projectDir = project.getProjectDirectory();
        sourcesDir = projectDir.getFileObject("src/java/test");
    }

    @Override protected void tearDown() throws Exception {
    }
    
    protected void testParseDocument(String file) {
        FileObject foFileToTest = sourcesDir.getFileObject(file);
        DataObject doFileToTest;
        
        try {
            doFileToTest = DataObject.find(foFileToTest);
            EditorCookie ec = (EditorCookie) doFileToTest.getCookie(EditorCookie.class);
            
            //open the document
            final BaseDocument doc = (BaseDocument)ec.openDocument();
            ec.open();

            RequestProcessor.Task task = RequestProcessor.getDefault().create(new Runnable(){
                public void run() {
                    Collection problems = (Collection) doc.getProperty("jee.problem_scaning.result");
                    
                    if (problems != null){
                        synchronized(problems){
                            System.err.println("problems.size()=" + problems.size());
                            
                            for (Object problem : problems){
                                getRef().println(problem);
                                System.err.println("problem=" + problem);
                            }
                        }
                    } else{
                        assertTrue("failed to read 'jee.problem_scaning.result' document property", false);
                    }
                }
            });
            
            task.schedule(PAUSE);
            task.waitFinished();
            ec.close();
            compareReferenceFiles();
            
        } catch (Exception ex) {
            ex.printStackTrace();
            fail("Excepction during test execution: " + ex.getMessage());
        }
    }
}
