/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.deployment.config;

import java.util.Collections;
import javax.enterprise.deploy.model.*;
import javax.enterprise.deploy.shared.ModuleType;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;

public class DeployableObjectImpl implements DeployableObject {
    
    final ModuleDeploymentSupport support;
    
    /** Creates new DeployableObjectImpl */
    DeployableObjectImpl(ModuleDeploymentSupport support) {
        this.support = support;
    }
    
    public ModuleType getType() { 
        return support.getType(); 
    }
    
    public DDBeanRoot getDDBeanRoot() {
        // PENDING this method doesn't have clear semantics anymore - should
        // use parameterized getDDBeanRoot()
        return support.getDDBeanRoot();
    }
    
    public DDBean[] getChildBean(String xpath) {
        return getDDBeanRoot().getChildBean(xpath);
    }
    
    public String[] getText(String xpath) {
        return getDDBeanRoot().getText(xpath);
    }
    
    public String getModuleDTDVersion() {
        return support.getVersion();
    }
     
    public java.util.Enumeration entries() {
        return Collections.enumeration(Collections.EMPTY_LIST);
    }
    
    public DDBeanRoot getDDBeanRoot(String filename) throws java.io.FileNotFoundException, javax.enterprise.deploy.model.exceptions.DDBeanCreateException {
        return support.getDDBeanRoot(ModuleDeploymentSupport.filenameToPath(filename, getType()));
    }
    
    public java.io.InputStream getEntry(String str) {
        return null;
    }
    
    public Class getClassFromScope(String str) {
        return support.getClassFromScope(str);
    }
    
    public J2eeModuleProvider getProvider() {
        return support.getProvider();
    }
}
