/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.tests.j2eeserver.plugin.jsr88;

import java.io.*;
import java.util.Collection;
import java.util.HashSet;
import javax.enterprise.deploy.model.*;
import javax.enterprise.deploy.shared.*;
import javax.enterprise.deploy.spi.*;
import javax.enterprise.deploy.spi.exceptions.*;


/**
 *
 * @author  gfink
 */
public class DepConfig implements DeploymentConfiguration {
    
    DeployableObject dobj;
    DepManager manager;
    Collection beans = new HashSet();
    
    /** Creates a new instance of DepFactory */
    public DepConfig(DeployableObject dobj, DepManager manager) {
        this.dobj = dobj; this.manager = manager;
    }
    
    public DConfigBeanRoot getDConfigBeanRoot(DDBeanRoot bean) throws ConfigurationException {
        ModuleType type = bean.getType();
        if(type == ModuleType.EAR) {
            EarConfigBean ret = new EarConfigBean(bean, this);
            beans.add(ret);
            return ret;
        }
        if(type == ModuleType.EJB) {
            EjbModuleConfigBean ret = new EjbModuleConfigBean(bean,
this);
            beans.add(ret);
            return ret;
        }
        if(type == ModuleType.WAR) {
            WebModuleConfigBean ret = new WebModuleConfigBean(bean,
this);
            beans.add(ret);
            return ret;
        }
        return null;
    }
    
    public DeployableObject getDeployableObject() {
        return dobj;
    }
    
    public void removeDConfigBean(DConfigBeanRoot dConfigBeanRoot) throws BeanNotFoundException {
    }
    
    public void restore(InputStream inputStream) throws ConfigurationException {
    }
    
    public DConfigBeanRoot restoreDConfigBean(InputStream inputStream, DDBeanRoot dDBeanRoot) throws ConfigurationException {
        throw new ConfigurationException();
    }
    
    public void save(OutputStream outputStream) throws ConfigurationException {
    }
    
    public void saveDConfigBean(OutputStream outputStream, DConfigBeanRoot dConfigBeanRoot) throws ConfigurationException {
    }
    
}
