/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.tests.j2eeserver.plugin.jsr88;

import javax.enterprise.deploy.spi.exceptions.*;
import javax.enterprise.deploy.spi.*;
import java.beans.*;
import javax.enterprise.deploy.model.*;

import java.util.*;

/**
 *
 * @author  gfink
 */
public class EjbModuleConfigBean implements DConfigBeanRoot {
    
    DDBean bean;
    DepConfig config;
    Collection children = new HashSet();
    String SESSION = "ejb-jar/enterprise-beans/session";
    String ENTITY = "ejb-jar/enterprise-beans/entity";
    
    public EjbModuleConfigBean(DDBean bean, DepConfig config) {
        this.bean = bean; this.config = config;
    }
      
    public DConfigBean getDConfigBean(DDBean dDBean) throws ConfigurationException {
        DConfigBean ret = null;
        if(dDBean.getXpath().endsWith(SESSION) || dDBean.getXpath().endsWith(ENTITY))
            ret = new EjbConfigBean(dDBean, this, config);
        if(ret != null) children.add(ret);
        return ret;
    }
    
    public DDBean getDDBean() {
        return bean;
    }
    
    public String[] getXpaths() {
        return new String[] { SESSION, ENTITY };
    }
    
    public void notifyDDChange(XpathEvent xpathEvent) {
    }
    
    public void removeDConfigBean(DConfigBean dConfigBean) throws BeanNotFoundException {
        children.remove(dConfigBean);
        propertyChangeSupport.firePropertyChange(dConfigBean.getClass().toString(),dConfigBean,null);
    }
    
      /** Utility field used by bound properties. */
      private PropertyChangeSupport propertyChangeSupport =  new PropertyChangeSupport(this);
      
      /** Holds value of property secure. */
      private String secure;
      
      /** Holds value of property securityDomain. */
      private String securityDomain;
      
      /** Holds value of property resourceManager. */
      private ResourceManager[] resourceManager;
      
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        propertyChangeSupport.addPropertyChangeListener(listener);
    }
    
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        propertyChangeSupport.removePropertyChangeListener(listener);
    }   
    
    /** Getter for property secure.
     * @return Value of property secure.
     */
    public String getSecure() {
        return this.secure;
    }
    
    /** Setter for property secure.
     * @param secure New value of property secure.
     */
    public void setSecure(String secure) {
        String oldSecure = this.secure;
        this.secure = secure;
        propertyChangeSupport.firePropertyChange("secure", oldSecure, secure);
    }
    
    /** Getter for property securityDomain.
     * @return Value of property securityDomain.
     */
    public String getSecurityDomain() {
        return this.securityDomain;
    }
    
    /** Setter for property securityDomain.
     * @param securityDomain New value of property securityDomain.
     */
    public void setSecurityDomain(String securityDomain) {
        String oldSecurityDomain = this.securityDomain;
        this.securityDomain = securityDomain;
        propertyChangeSupport.firePropertyChange("securityDomain", oldSecurityDomain, securityDomain);
    }
    
    /** Indexed getter for property resourceManager.
     * @param index Index of the property.
     * @return Value of the property at <CODE>index</CODE>.
     */
    public ResourceManager getResourceManager(int index) {
        return this.resourceManager[index];
    }
    
    /** Getter for property resourceManager.
     * @return Value of property resourceManager.
     */
    public ResourceManager[] getResourceManager() {
        return this.resourceManager;
    }
    
    /** Indexed setter for property resourceManager.
     * @param index Index of the property.
     * @param resourceManager New value of the property at <CODE>index</CODE>.
     */
    public void setResourceManager(int index, ResourceManager resourceManager) {
        this.resourceManager[index] = resourceManager;
        propertyChangeSupport.firePropertyChange("resourceManager", null, null );
    }
    
    /** Setter for property resourceManager.
     *  PENDING should be package private, but NB beaninfo editor chokes on it?
     * @param resourceManager New value of property resourceManager.
     */
    public void setResourceManager(ResourceManager[] resourceManager) {
        ResourceManager[] oldResourceManager = this.resourceManager;
        this.resourceManager = resourceManager;
        propertyChangeSupport.firePropertyChange("resourceManager", oldResourceManager, resourceManager);
    }
    
    // PENDING use reference counts and track removes too.
    void addResource(String resource) {
        for(int i = 0; i < resourceManager.length; i++)
            if(resourceManager[i].getResourceName().equals(resource)) return;
        ResourceManager[] newManagers = new ResourceManager[resourceManager.length + 1];
        for(int i = 0; i < resourceManager.length; i++)
            newManagers[i] = resourceManager[i];
        ResourceManager manager = new ResourceManager(resource);
        newManagers[resourceManager.length] = manager;
        setResourceManager(newManagers);
    }
    
    public DConfigBean getDConfigBean(DDBeanRoot dDBeanRoot) {
        return null;
    }
    
}
