/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.tests.j2eeserver.plugin.jsr88;

import javax.enterprise.deploy.spi.exceptions.*;
import javax.enterprise.deploy.spi.*;
import java.beans.*;
import javax.enterprise.deploy.model.*;


/**
 *
 * @author  gfink
 */
public class ResourceRefConfigBean implements DConfigBean {
    
    DDBean bean;
    DepConfig config;
    EjbModuleConfigBean module;
    
    public ResourceRefConfigBean(DDBean bean, DepConfig config) {
        this.bean = bean; this.config = config;
        this.resourceName = bean.getText();
    }
      
    public ResourceRefConfigBean(DDBean bean, EjbModuleConfigBean module, DepConfig config) {
        this(bean, config);
        this.module = module;
    }
      
    public DConfigBean getDConfigBean(DDBean dDBean) throws ConfigurationException {
        return null;
    }
    
    public DDBean getDDBean() {
        return bean;
    }
    
    public String[] getXpaths() {
        return null;
    }
    
    public void notifyDDChange(XpathEvent xpathEvent) {
    }
    
    public void removeDConfigBean(DConfigBean dConfigBean) throws BeanNotFoundException {
    }
    
      /** Utility field used by bound properties. */
      private PropertyChangeSupport propertyChangeSupport =  new PropertyChangeSupport(this);
      
      /** Holds value of property resourceName. */
      private String resourceName;
      
      /** Holds value of property jndiName. */
      private String jndiName;
      
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        propertyChangeSupport.addPropertyChangeListener(listener);
    }
    
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        propertyChangeSupport.removePropertyChangeListener(listener);
    }   
    
    /** Getter for property resourceName.
     * @return Value of property resourceName.
     */
    public String getResourceName() {
        return this.resourceName;
    }
    
    /** Getter for property jndiName.
     * @return Value of property jndiName.
     */
    public String getJndiName() {
        return this.jndiName;
    }
    
    /** Setter for property jndiName.
     * @param jndiName New value of property jndiName.
     */
    public void setJndiName(String jndiName) {
        String oldJndiName = this.jndiName;
        this.jndiName = jndiName;
        propertyChangeSupport.firePropertyChange("jndiName", oldJndiName, jndiName);
    }
    
}
