/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.tests.j2eeserver.plugin.jsr88;

import javax.enterprise.deploy.spi.exceptions.*;
import javax.enterprise.deploy.spi.*;
import java.beans.*;
import javax.enterprise.deploy.model.*;

import java.util.*;

/**
 *
 * @author  gfink
 */
public class WebModuleConfigBean implements DConfigBeanRoot {
    
    DDBean bean;
    DepConfig config;
    Collection children = new HashSet();
    String WEBAPP = "/";
    String EJBREF = "web-app/ejb-ref";
    String RESOURCEREF = "web-app/resource-ref/res-ref-name";
    
    public WebModuleConfigBean(DDBean bean, DepConfig config) {
        this.bean = bean; this.config = config;
    }
      
    public DConfigBean getDConfigBean(DDBean dDBean) throws ConfigurationException {
        DConfigBean ret = null;
        if(dDBean.getXpath().endsWith(EJBREF))
            ret = new EjbRefConfigBean(dDBean, config);
        else if(dDBean.getXpath().endsWith(RESOURCEREF))
            ret = new ResourceRefConfigBean(dDBean, config);
        else if (dDBean.getXpath().endsWith(WEBAPP))
            ret = this;
        if(ret != null) children.add(ret);
        return ret;
    }
    
    public DDBean getDDBean() {
        return bean;
    }
    
    public String[] getXpaths() {
        //return new String[] { WEBAPP, RESOURCEREF, EJBREF };
        return new String[] { RESOURCEREF, EJBREF };
    }
    
    public void notifyDDChange(XpathEvent xpathEvent) {
    }
    
    public void removeDConfigBean(DConfigBean dConfigBean) throws BeanNotFoundException {
        children.remove(dConfigBean);
        propertyChangeSupport.firePropertyChange(dConfigBean.getClass().toString(),dConfigBean,null);
    }
    
      /** Utility field used by bound properties. */
      private PropertyChangeSupport propertyChangeSupport =  new PropertyChangeSupport(this);
      
      /** Holds value of property securityDomain. */
      private String securityDomain;
      
      /** Holds value of property contextRoot. */
      private String contextRoot;
      
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        propertyChangeSupport.addPropertyChangeListener(listener);
    }
    
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        propertyChangeSupport.removePropertyChangeListener(listener);
    }   
    
    /** Getter for property securityDomain.
     * @return Value of property securityDomain.
     */
    public String getSecurityDomain() {
        return this.securityDomain;
    }
    
    /** Setter for property securityDomain.
     * @param securityDomain New value of property securityDomain.
     */
    public void setSecurityDomain(String securityDomain) {
        String oldSecurityDomain = this.securityDomain;
        this.securityDomain = securityDomain;
        propertyChangeSupport.firePropertyChange("securityDomain", oldSecurityDomain, securityDomain);
    }
    
    /** Getter for property contextRoot.
     * @return Value of property contextRoot.
     *
     */
    public String getContextRoot() {
        return this.contextRoot;
    }
    
    /** Setter for property contextRoot.
     * @param contextRoot New value of property contextRoot.
     *
     */
    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }
    
    public DConfigBean getDConfigBean(DDBeanRoot dDBeanRoot) {
        return null;
    }
    
}
