/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.editor.ext.java;

/**
* Java completion class
*
* @author Miloslav Metelka
* @version 1.00
*/

public interface JCClass extends Comparable {

    /** Get name of the class without package specification */
    public String getName();

    /** Get package where the class is placed */
    public String getPackageName();

    /** Get full name consisting of class name and package name */
    public String getFullName();

    /** Get offset in source files */
    public int getTagOffset();

    /** Is this class an interface? */
    public boolean isInterface();

    /** Get modifiers for this class */
    public int getModifiers();

    /** Get superclass of this class */
    public JCClass getSuperclass();

    /** Get interfaces this class implements or the interfaces this
    * interface extends.
    */
    public JCClass[] getInterfaces();

    /** Get fields that this class contains */
    public JCField[] getFields();

    /** Get constructors that this class contains */
    public JCConstructor[] getConstructors();

    /** Get methods that this class contains */
    public JCMethod[] getMethods();

}
