/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.editor.java;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Acceptor;
import org.netbeans.editor.AcceptorFactory;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsNames;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.java.JavaTokenContext;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.ErrorManager;


/**A testing Completion Provider that provides abbreviations as result.
 *
 * @author Jan Lahoda
 */
public class AbbreviationsCompletionProvider implements CompletionProvider {
    
    /**Whether only full match of the abbreviation code should be considered for the completion.
     * E.g. if NON_EXACT_MATCH == true, ser| would provide System.err.println("|"); abbreviation,
     * if NON_EXACT_MATCH == false, ser| would not provide the abbreviation, but serr| would.
     */
    private static final boolean NON_EXACT_MATCH = Boolean.getBoolean("nebeans.editor.completion.abbreviations.nonexactmatch");
    
    /**Enable the AbbreviationsCompletionProvider
     */
    private static final boolean ENABLED = Boolean.getBoolean("nebeans.editor.completion.abbreviations.enable");
    
    /** Creates a new instance of JavaDocCompletionProvider */
    public AbbreviationsCompletionProvider() {
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }

    public CompletionTask createTask(int queryType, JTextComponent component) {
        if (queryType == COMPLETION_QUERY_TYPE)
            return new AsyncCompletionTask(new Query(), component);
        return null;
    }
    
    static class Query extends AsyncCompletionQuery {
        
        protected void  query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            List/*<CompletionItem>*/ results = queryImpl(doc, caretOffset);
            assert (results != null);
            resultSet.addAllItems(results);
            resultSet.finish();
        }
    }
    
    public static List/*<CompletionItem>*/ queryImpl(Document doc, int offset) {
        if (!ENABLED || !(doc instanceof BaseDocument))
            return Collections.EMPTY_LIST;
        BaseDocument bdoc = (BaseDocument)doc;
        // ignore comments, strings
        try {
            TokenID token = ((ExtSyntaxSupport)bdoc.getSyntaxSupport()).getTokenID(offset);
            int id = token != null ? token.getNumericID() : 0;
            if (id == JavaTokenContext.STRING_LITERAL_ID || id == JavaTokenContext.CHAR_LITERAL_ID || id == JavaTokenContext.LINE_COMMENT_ID || id == JavaTokenContext.BLOCK_COMMENT_ID)
                return Collections.EMPTY_LIST;
        } catch (BadLocationException e) {
        }
        
        try {
            Class kitClass = bdoc.getKitClass();
            
            if (kitClass != null) {
                BaseOptions o = BaseOptions.getOptions(kitClass);
                Map abbrevs = o.getAbbrevMap();
                int maxCodeLength = 0;
                
                for (Iterator i = abbrevs.keySet().iterator(); i.hasNext(); ) {
                    String key = (String) i.next();
                    
                    if (key.length() > maxCodeLength) {
                        maxCodeLength = key.length();
                    }
                }
                
                //find the just-typed abbreviation key:
                Acceptor abbrevAcceptor = (Acceptor) Settings.getValue(kitClass, SettingsNames.ABBREV_RESET_ACCEPTOR);
                
                if (abbrevAcceptor == null) {
                    abbrevAcceptor = AcceptorFactory.NON_JAVA_IDENTIFIER;
                }
                
                String potentialPrefix = doc.getText(offset - maxCodeLength - 1, maxCodeLength + 1);
                int index = 0;
                
                for (; index < maxCodeLength + 1; index++) {
                    if (abbrevAcceptor.accept(potentialPrefix.charAt(maxCodeLength - index)))
                        break;
                }
                
                if (index == 0) {
                    //does not seem to be a viable prefix, end:
                    return Collections.EMPTY_LIST;
                }
                
                String prefix = potentialPrefix.substring(maxCodeLength - index + 1);
                
                //TODO: should create whole list and then filter, but for now:
                List result = new ArrayList();
                
                for (Iterator i = abbrevs.keySet().iterator(); i.hasNext(); ) {
                    String key = (String) i.next();
                    
                    if ((NON_EXACT_MATCH && key.startsWith(prefix)) || key.equals(prefix)) {
                        result.add(NbJavaJMICompletionQuery.getJMIItemFactory().createStringResultItem((String ) abbrevs.get(key)));
                    }
                }
                
                return result;
            }
        } catch (BadLocationException e) {
            ErrorManager.getDefault().notify(e);
        }
        return Collections.EMPTY_LIST;
    }
    
}
