/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.editor.java;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/**
 *
 * @author  Jan Becicka
 */
public class FixImportsProgressPanel extends JPanel {
    
    /** Creates new form UndoProgressPanel */
    FixImportsProgressPanel() {
        //super(WindowManager.getDefault().getMainWindow(),true);
        initComponents();
        setBounds(Utilities.findCenterBounds(getSize()));
        //setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
    }
    
    public void start(final int count) {
        progress.setMaximum(count);
    }
    
    public void step() {
        progress.setValue(progress.getValue() + 1);
    }
    
    public void stop() {
        progress.setValue(progress.getMaximum());
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jPanel1 = new javax.swing.JPanel();
        progress = new javax.swing.JProgressBar();
        undoLabel = new javax.swing.JLabel();

        setLayout(new java.awt.BorderLayout());

        jPanel1.setLayout(new java.awt.BorderLayout());

        jPanel1.setBorder(javax.swing.BorderFactory.createEmptyBorder(12, 12, 11, 11));
        jPanel1.add(progress, java.awt.BorderLayout.CENTER);

        undoLabel.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/editor/java/Bundle").getString("FixImportsProgressLabel_Lbl"));
        undoLabel.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 6, 1));
        jPanel1.add(undoLabel, java.awt.BorderLayout.NORTH);

        add(jPanel1, java.awt.BorderLayout.CENTER);

    }
    // </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel1;
    javax.swing.JProgressBar progress;
    private javax.swing.JLabel undoLabel;
    // End of variables declaration//GEN-END:variables
    
}
