/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.editor.java;

import java.awt.event.ActionEvent;
import java.util.Set;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.editor.BaseAction;

/**
 * Open java source according to the given expression.
 *
 * @author Miloslav Metelka
 * @version 1.0
 */

public class JavaFastOpenAction extends CallableSystemAction {
    
    private static JavaFastOpenAction instance;

    public JavaFastOpenAction () {
        super();
        putValue("noIconInMenu", Boolean.TRUE); // NOI18N
    }
    
    public void actionPerformed(ActionEvent e) {
        SwingUtilities.invokeLater (new Runnable() {
            public void run() {
                NbJavaJMIFastOpen.showFastOpen();
            }
        });
    }
    
    public static synchronized JavaFastOpenAction getInstance(){
        if (instance == null){
            instance = new JavaFastOpenAction();
            String trimmedName = NbBundle.getBundle(JavaKit.class).getString("goto-class-trimmed"); //NOI18N
            instance.putValue(org.netbeans.editor.ext.ExtKit.TRIMMED_TEXT, trimmedName);
            instance.putValue(BaseAction.POPUP_MENU_TEXT, trimmedName);
        }
        return instance;
    }
    
    public String getName() {
        return NbBundle.getBundle(JavaFastOpenAction.class).getString("NAME_JavaFastOpenAction"); // NOI18N
    }
    
    public final HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    /** Actually perform the action.
     * This is the method which should be called programmatically.
     * Presenters in {@link Actions} use this.
     */
    public void performAction() {
    }
    
    public boolean isEnabled() {
        /* If there are no paths in registry, the action shoud be disabled (#46632)*/        
        Set sources = GlobalPathRegistry.getDefault().getPaths(ClassPath.SOURCE);
        Set compile = GlobalPathRegistry.getDefault().getPaths(ClassPath.COMPILE);
        Set boot = GlobalPathRegistry.getDefault().getPaths(ClassPath.BOOT);
        return !(sources.isEmpty() && compile.isEmpty() && boot.isEmpty());
    }
    

}
