/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.editor.java;

import java.lang.reflect.Modifier;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.netbeans.editor.ext.java.JCPaintComponent;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.openide.util.Utilities;

/**
 *
 * @author  Martin Roskanin
 */
public class NbJCPaintComponent extends JCPaintComponent{
    
    static final String PACKAGE = "org/netbeans/modules/editor/resources/completion/defaultFolder.gif"; // NOI18N
    static final String CLASS = "org/netbeans/modules/editor/resources/completion/class_16.png"; // NOI18N
    static final String INTERFACE = "org/netbeans/modules/editor/resources/completion/interface.png"; // NOI18N

    static final String FIELD_PUBLIC = "org/netbeans/modules/editor/resources/completion/field_16.png"; //NOI18N
    static final String FIELD_PROTECTED = "org/netbeans/modules/editor/resources/completion/field_protected_16.png"; //NOI18N
    static final String FIELD_PACKAGE = "org/netbeans/modules/editor/resources/completion/field_package_private_16.png"; //NOI18N
    static final String FIELD_PRIVATE = "org/netbeans/modules/editor/resources/completion/field_private_16.png"; //NOI18N        
    
    static final String FIELD_ST_PUBLIC = "org/netbeans/modules/editor/resources/completion/field_static_16.png"; //NOI18N
    static final String FIELD_ST_PROTECTED = "org/netbeans/modules/editor/resources/completion/field_static_protected_16.png"; //NOI18N
    static final String FIELD_ST_PACKAGE = "org/netbeans/modules/editor/resources/completion/field_static_package_private_16.png"; //NOI18N
    static final String FIELD_ST_PRIVATE = "org/netbeans/modules/editor/resources/completion/field_static_private_16.png"; //NOI18N

    static final String CONSTRUCTOR_PUBLIC = "org/netbeans/modules/editor/resources/completion/constructor_16.png"; //NOI18N
    static final String CONSTRUCTOR_PROTECTED = "org/netbeans/modules/editor/resources/completion/constructor_protected_16.png"; //NOI18N
    static final String CONSTRUCTOR_PACKAGE = "org/netbeans/modules/editor/resources/completion/constructor_package_private_16.png"; //NOI18N
    static final String CONSTRUCTOR_PRIVATE = "org/netbeans/modules/editor/resources/completion/constructor_private_16.png"; //NOI18N

    static final String METHOD_PUBLIC = "org/netbeans/modules/editor/resources/completion/method_16.png"; //NOI18N
    static final String METHOD_PROTECTED = "org/netbeans/modules/editor/resources/completion/method_protected_16.png"; //NOI18N
    static final String METHOD_PACKAGE = "org/netbeans/modules/editor/resources/completion/method_package_private_16.png"; //NOI18N
    static final String METHOD_PRIVATE = "org/netbeans/modules/editor/resources/completion/method_private_16.png"; //NOI18N        

    static final String METHOD_ST_PUBLIC = "org/netbeans/modules/editor/resources/completion/method_static_16.png"; //NOI18N
    static final String METHOD_ST_PROTECTED = "org/netbeans/modules/editor/resources/completion/method_static_protected_16.png"; //NOI18N
    static final String METHOD_ST_PRIVATE = "org/netbeans/modules/editor/resources/completion/method_static_private_16.png"; //NOI18N
    static final String METHOD_ST_PACKAGE = "org/netbeans/modules/editor/resources/completion/method_static_package_private_16.png"; //NOI18N
    
    public static class NbPackagePaintComponent extends JCPaintComponent.PackagePaintComponent{
        
        public NbPackagePaintComponent(){
            super();
        }
        
        protected Icon getIcon(){
            Icon superIcon = super.getIcon();
            if (superIcon != null) return superIcon;

            Icon newIcon = UIManager.getIcon("FileView.directoryIcon"); //NOI18N
            if (newIcon == null) newIcon = new ImageIcon(Utilities.loadImage(PACKAGE));
            
            setIcon(newIcon);
            return newIcon;            
        }
    }
    
    public static class NbClassPaintComponent extends JCPaintComponent.ClassPaintComponent{
        
        public NbClassPaintComponent(){
            super();
        }
        
        protected Icon getIcon(){
            Icon superIcon = super.getIcon();
            if (superIcon != null) return superIcon;
            ImageIcon newIcon = new ImageIcon(Utilities.loadImage(CLASS));
            setIcon(newIcon);
            return newIcon;            
        }
    }

    public static class NbInterfacePaintComponent extends JCPaintComponent.InterfacePaintComponent{
        
        public NbInterfacePaintComponent(){
            super();
        }
        
        protected Icon getIcon(){
            Icon superIcon = super.getIcon();
            if (superIcon != null) return superIcon;
            ImageIcon newIcon = new ImageIcon(Utilities.loadImage(INTERFACE));
            setIcon(newIcon);
            return newIcon;            
        }
        
    }

    
    public static class NbFieldPaintComponent extends JCPaintComponent.FieldPaintComponent{

        private static Icon[][] icon = new Icon[2][4];
        
        public NbFieldPaintComponent(){
            super();
        }
        
        protected Icon getIcon(){
            String iconPath = FIELD_PUBLIC;
            int level = JavaCompletion.getLevel(getModifiers());
            boolean isStatic = ((getModifiers() & Modifier.STATIC) != 0);
            Icon cachedIcon = icon[isStatic ? 0 : 1][level];
            if (cachedIcon != null) return cachedIcon;
            if (isStatic){
                //static field
                switch (level) {
                    case JavaCompletion.PRIVATE_LEVEL:
                        iconPath = FIELD_ST_PRIVATE;
                        break;

                    case JavaCompletion.PACKAGE_LEVEL:
                        iconPath = FIELD_ST_PACKAGE;
                        break;

                    case JavaCompletion.PROTECTED_LEVEL:
                        iconPath = FIELD_ST_PROTECTED;
                        break;

                    case JavaCompletion.PUBLIC_LEVEL:
                        iconPath = FIELD_ST_PUBLIC;
                        break;
                }
            }else{
                switch (level) {
                    case JavaCompletion.PRIVATE_LEVEL:
                        iconPath = FIELD_PRIVATE;
                        break;

                    case JavaCompletion.PACKAGE_LEVEL:
                        iconPath = FIELD_PACKAGE;
                        break;

                    case JavaCompletion.PROTECTED_LEVEL:
                        iconPath = FIELD_PROTECTED;
                        break;

                    case JavaCompletion.PUBLIC_LEVEL:
                        iconPath = FIELD_PUBLIC;
                        break;
                }
            }
            ImageIcon newIcon = new ImageIcon(Utilities.loadImage(iconPath));
            icon[isStatic ? 0 : 1][level] = newIcon;
            return newIcon;            
        }
    
    }    
    
    public static class NbMethodPaintComponent extends JCPaintComponent.MethodPaintComponent{
        
        private static Icon[][] icon = new Icon[2][4];
        
        public NbMethodPaintComponent(){
            super();
        }
        
        protected Icon getIcon(){
            String iconPath = METHOD_PUBLIC;
            int level = JavaCompletion.getLevel(getModifiers());
            boolean isStatic = (getModifiers() & Modifier.STATIC) != 0;
            Icon cachedIcon = icon[isStatic ? 0 : 1][level];
            if (cachedIcon != null) return cachedIcon;
            if (isStatic){
                //static method
                switch (level) {
                    case JavaCompletion.PRIVATE_LEVEL:
                        iconPath = METHOD_ST_PRIVATE;
                        break;

                    case JavaCompletion.PACKAGE_LEVEL:
                        iconPath = METHOD_ST_PACKAGE;
                        break;

                    case JavaCompletion.PROTECTED_LEVEL:
                        iconPath = METHOD_ST_PROTECTED;
                        break;

                    case JavaCompletion.PUBLIC_LEVEL:
                        iconPath = METHOD_ST_PUBLIC;
                        break;
                }
            }else{
                switch (level) {
                    case JavaCompletion.PRIVATE_LEVEL:
                        iconPath = METHOD_PRIVATE;
                        break;

                    case JavaCompletion.PACKAGE_LEVEL:
                        iconPath = METHOD_PACKAGE;
                        break;

                    case JavaCompletion.PROTECTED_LEVEL:
                        iconPath = METHOD_PROTECTED;
                        break;

                    case JavaCompletion.PUBLIC_LEVEL:
                        iconPath = METHOD_PUBLIC;
                        break;
                }
            }
            ImageIcon newIcon = new ImageIcon(Utilities.loadImage(iconPath));
            icon[isStatic ? 0 : 1][level] = newIcon;
            return newIcon;            
        }
        
        
    }
    
    public static class NbConstructorPaintComponent extends JCPaintComponent.ConstructorPaintComponent{
        
        private static Icon[] icon = new Icon[4];
        
        public NbConstructorPaintComponent(){
            super();
        }

        
        protected Icon getIcon(){
            String iconPath = CONSTRUCTOR_PUBLIC;
            int level = JavaCompletion.getLevel(getModifiers());
            if (icon[level] != null) return icon[level];
            switch (level) {
                case JavaCompletion.PRIVATE_LEVEL:
                    iconPath = CONSTRUCTOR_PRIVATE;
                    break;

                case JavaCompletion.PACKAGE_LEVEL:
                    iconPath = CONSTRUCTOR_PACKAGE;
                    break;

                case JavaCompletion.PROTECTED_LEVEL:
                    iconPath = CONSTRUCTOR_PROTECTED;
                    break;

                case JavaCompletion.PUBLIC_LEVEL:
                    iconPath = CONSTRUCTOR_PUBLIC;
                    break;
            }
            ImageIcon newIcon = new ImageIcon(Utilities.loadImage(iconPath));
            icon[level] = newIcon;
            return newIcon;            
        }
        
    }
    
}
