/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.editor.java;

import java.text.MessageFormat;
import javax.swing.JEditorPane;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JavaFastOpen;
import org.netbeans.editor.Utilities;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.EditorCookie;
import org.openide.util.NbBundle;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;

import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.java.editor.options.JavaOptions;
import org.netbeans.modules.editor.options.BaseOptions;
import org.openide.ErrorManager;
import org.openide.cookies.EditCookie;
import org.openide.util.RequestProcessor;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.editor.ext.java.JCResultItem;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;

/**
 * Open java source using all available parser DBs.
 *
 * @author Miloslav Metelka
 * @version 1.0
 */

public class NbJavaFastOpen extends JavaFastOpen {


    protected JCFinder getFinder() {
        return JCFinderFactory.getDefault().getGlobalFinder();
    }

    protected List findClasses(String exp, boolean caseSensitive, boolean includeInnerClasses, boolean includeLibraryClasses) {
        List ret = new ArrayList();
        JCFinder finder = getFinder();
        List classes = finder.findClasses(null, exp, false);

        Iterator it = classes.iterator();
        while (it.hasNext()) {
            JCClass cls = (JCClass)it.next();
            if (cls.getName().indexOf('.') == -1) {
                ret.add(new JCResultItem.ClassResultItem(cls, true));
            }
        }
        return ret;
    }

    public static void showFastOpen() {
        // set class or class fragment from current cursor position
        // Issue#: 10639 
        Node[] arr = TopComponent.getRegistry ().getActivatedNodes ();
        String initSearchText = null;
        if (arr.length > 0) {
            EditorCookie ec = (EditorCookie) arr[0].getCookie (EditorCookie.class);
            if (ec != null) {
                JEditorPane[] openedPanes = ec.getOpenedPanes ();
                if (openedPanes != null) {
                    initSearchText = Utilities.getSelectionOrIdentifier(openedPanes [0]);
                    if (initSearchText != null) {
                        if (BaseOptions.getOptions(JavaKit.class) instanceof JavaOptions){
                            // initSearchText JCCompletion via JavaKit call
                            JavaOptions jo = (JavaOptions)BaseOptions.getOptions(JavaKit.class);
                        }
                        JCFinder finder = JCFinderFactory.getDefault().getGlobalFinder();
                        java.util.List l = finder.findClasses(null , initSearchText, false);
                        if (l.size () < 1) initSearchText = null;
                    }
                }
            }
        }

        if (fastOpen == null) {
            RequestProcessor.getDefault().post(new ShowDialogRunnable(initSearchText));
        } else {
            new ShowDialogRunnable(initSearchText).run(); // do directly
        }
        
    }
    
    private void openSourceFO(FileObject fo){
        DataObject dob;
        try {
            dob = DataObject.find(fo);
        } catch (DataObjectNotFoundException e) {
            ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, e);
            dob = null;
        }
        
        if (dob != null) {
            EditCookie ec = (EditCookie)dob.getCookie(EditCookie.class);
            if (ec != null) {
                ec.edit();
            } else {
                OpenCookie oc = (OpenCookie)dob.getCookie(OpenCookie.class);
                if (oc != null) {
                    oc.open();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
    }
    
    protected void openSource(Object item, int order) {
        JCClass cls = null;        
        if (item instanceof JCClass) {
            cls = (JCClass)item;
        } else  if (item instanceof JCResultItem.ClassResultItem){
            cls = (JCClass)((JCResultItem.ClassResultItem)item).getAssociatedObject(); 
        }
        
        if (cls!=null){
            FileObject fo = findResource(cls, order);

            if (fo != null) {
                openSourceFO(fo);
            } else { // Class not found in filesystems

                String msg = NbBundle.getBundle(JavaKit.class).getString(
                    "goto_source_source_not_found"); // NOI18N
                msg = MessageFormat.format(msg, new Object [] { cls.getFullName() } );
                org.openide.DialogDisplayer.getDefault().notify(new NotifyDescriptor.Message(msg));
            }
        }
    }
    

    private FileObject findResource(JCClass cls, int order) {
        HashMap alreadyTested = new HashMap();
        String name = cls.getPackageName().replace('.', '/') + "/" + cls.getName() + ".java"; // NOI18N

        // first check the SOURCE classpath
        Set set = GlobalPathRegistry.getDefault().getPaths(ClassPath.SOURCE);
        Iterator it = set.iterator();
        while (it.hasNext()) {
            ClassPath cp = (ClassPath)it.next();
            if (alreadyTested.get(cp) != null) {
                continue;
            }
            alreadyTested.put(cp, cp);
            FileObject fo = cp.findResource(name);
            if (fo != null) {
                if (order == 0) {
                    return fo;
                } else {
                    // continue searching
                    order--;
                }
            }
        }
        
        // now check the COMPILE and BOOT classpaths
        ArrayList list = new ArrayList(GlobalPathRegistry.getDefault().getPaths(ClassPath.COMPILE));
        list.addAll(GlobalPathRegistry.getDefault().getPaths(ClassPath.BOOT));
        it = list.iterator();
        while (it.hasNext()) {
            ClassPath cp = (ClassPath)it.next();
            if (alreadyTested.get(cp) != null) {
                continue;
            }
            alreadyTested.put(cp, cp);
            
            Iterator it2 = cp.entries().iterator();
            while (it2.hasNext()) {
                ClassPath.Entry entry = (ClassPath.Entry)it2.next();
                FileObject[] sroots = SourceForBinaryQuery.findSourceRoots(entry.getURL()).getRoots();
                List ll = Arrays.asList(sroots);
                if (alreadyTested.get(ll) != null) {
                    continue;
                }
                alreadyTested.put(ll, ll);
                if (sroots.length > 0) {
                    ClassPath sources = ClassPathSupport.createClassPath(sroots);
                    FileObject fo = sources.findResource(name);
                    if (fo != null) {
                        if (order == 0) {
                            return fo;
                        } else {
                            // continue searching
                            order--;
                        }
                    }
                }
            }
            
            FileObject fo = cp.findResource(name);
            if (fo != null) {
                if (order == 0) {
                    return fo;
                } else {
                    // continue searching
                    order--;
                }
            }
            
        }
        
        return null;
    }

    protected Class getKitClass() {
        return JavaKit.class;
    }

    protected void setCaseSensitive(boolean caseSensitive) {
        Class kitClass = getKitClass();
        if (kitClass != null) {
            BaseOptions bop = BaseOptions.getOptions(kitClass);
            if (bop instanceof JavaOptions){
                ((JavaOptions)bop).setGotoClassCaseSensitive(caseSensitive);
            }
        }
    }

    protected void setIncludeInnerClasses(boolean includeInnerClasses) {
        Class kitClass = getKitClass();
        if (kitClass != null) {
            BaseOptions bop = BaseOptions.getOptions(kitClass);
            if (bop instanceof JavaOptions){
                ((JavaOptions)bop).setGotoClassShowInnerClasses(includeInnerClasses);
            }
        }
    }

    protected void setIncludeLibraryClasses(boolean includeLibraryClasses) {
        Class kitClass = getKitClass();
        if (kitClass != null) {
            BaseOptions bop = BaseOptions.getOptions(kitClass);
            if (bop instanceof JavaOptions){
                ((JavaOptions)bop).setGotoClassShowLibraryClasses(includeLibraryClasses);
            }
        }
    }

    private static class ShowDialogRunnable implements Runnable {
        
        private final String searchText;
        
        /** Whether to post the request to Event Dispatch Thread */
        private boolean postToEDT;
        
        ShowDialogRunnable(String searchText) {
            this.searchText = searchText;
            this.postToEDT = true;
        }
        
        public void run() {
            if (postToEDT) {
                postToEDT = false;
                Utilities.runInEventDispatchThread(this);

            } else { // execute directly
                if (fastOpen == null) {
                    fastOpen = new NbJavaFastOpen();
                }
                if (searchText != null) {
                    fastOpen.setSearchText (searchText);
                }
                fastOpen.setDialogVisible(true);
            }
        }
    }

}
