/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.editor.java;

import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.java.JavaFastOpen;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.java.editor.options.JavaOptions;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;

import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

import java.text.MessageFormat;
import java.util.*;
import java.awt.event.ActionEvent;
import javax.swing.JEditorPane;
import org.netbeans.modules.javacore.api.JavaModel;

/**
 * Open java source using java JMI interfaces.
 *
 * @author Dusan Balek
 * @version 1.0
 */

public class NbJavaJMIFastOpen extends JavaFastOpen {
    
    private static final String SCAN_IN_PROGRESS[] = new String[]{
        NbBundle.getBundle(NbJavaJMIFastOpen.class).getString("scanning-in-progress") // NOI18N
    };
    
    private static final Vector EMPTY_VECTOR = new Vector();

    private boolean breakloop;
    String oldExp = null;

    public static void showFastOpen() {
        // set class or class fragment from current cursor position
        // Issue#: 10639
        Node[] arr = TopComponent.getRegistry ().getActivatedNodes ();
        String initSearchText = null;
        if (arr.length > 0) {
            EditorCookie ec = (EditorCookie) arr[0].getCookie (EditorCookie.class);
            if (ec != null) {
                JEditorPane[] openedPanes = ec.getOpenedPanes ();
                if (openedPanes != null) {
                    initSearchText = Utilities.getSelectionOrIdentifier(openedPanes [0]);
                    if (!org.openide.util.Utilities.isJavaIdentifier(initSearchText))
                        initSearchText = null;
                }
            }
        }
        if (fastOpen == null) {
            fastOpen = new NbJavaJMIFastOpen();
        }
        if (initSearchText != null) {
            fastOpen.setSearchText(initSearchText);
        }
        fastOpen.setDialogVisible(true);
    }
    
    protected void postUpdate() {
        if (JavaMetamodel.getManager().isScanInProgress()){
            String searchText = getSearchText();
            if (searchText != null && searchText.length()>0){
                getResultList().setListData(SCAN_IN_PROGRESS);
            } else {
                getResultList().setListData(EMPTY_VECTOR);
            }
        }
        if (oldExp != null && !getSearchText().equals(oldExp))
            breakloop = true;
        super.postUpdate();
    }

    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == getButtons()[0] || src == getPanel() ) { // Open
            setCaseSensitive(caseSensitive);
            setIncludeInnerClasses(includeInnerClasses);
            setIncludeLibraryClasses(includeLibraryClasses);
            setDialogVisible(false);
            final int selIndex = getResultList().getSelectedIndex();
            if (selIndex >= 0) {
                RequestProcessor.getDefault().post(new Runnable() {
                    public void run() {
                        Object item = getResultList().getModel().getElementAt(selIndex);
                        JavaClass cls = item instanceof NbJMIResultItem.ClassResultItem ? (JavaClass)((NbJMIResultItem.ClassResultItem)item).getAssociatedObject() : null;
                        if (cls != null) {
                            if (!JMIUtils.openElement(cls)) {
                                String msg = NbBundle.getBundle(JavaKit.class).getString("goto_source_source_not_found"); // NOI18N
                                msg = MessageFormat.format(msg, new Object [] { cls.getName() } );
                                org.openide.DialogDisplayer.getDefault().notify(new NotifyDescriptor.Message(msg));
                            }
                        }
                    }
                });
            }
        } else {
            super.actionPerformed(evt);
        }
    }

    protected Class getKitClass() {
        return JavaKit.class;
    }

    protected void setCaseSensitive(boolean caseSensitive) {
        Class kitClass = getKitClass();
        if (kitClass != null) {
            BaseOptions bop = BaseOptions.getOptions(kitClass);
            if (bop instanceof JavaOptions){
                ((JavaOptions)bop).setGotoClassCaseSensitive(caseSensitive);
            }
        }
    }

    protected void setIncludeInnerClasses(boolean includeInnerClasses) {
        Class kitClass = getKitClass();
        if (kitClass != null) {
            BaseOptions bop = BaseOptions.getOptions(kitClass);
            if (bop instanceof JavaOptions){
                ((JavaOptions)bop).setGotoClassShowInnerClasses(includeInnerClasses);
            }
        }
    }

    protected void setIncludeLibraryClasses(boolean includeLibraryClasses) {
        Class kitClass = getKitClass();
        if (kitClass != null) {
            BaseOptions bop = BaseOptions.getOptions(kitClass);
            if (bop instanceof JavaOptions){
                ((JavaOptions)bop).setGotoClassShowLibraryClasses(includeLibraryClasses);
            }
        }
    }

    protected List findClasses(String exp, boolean caseSensitive, boolean includeInnerClasses, boolean includeLibraryClasses) {
        List ret = new ArrayList();
        Set cpRoots = GlobalPathRegistry.getDefault().getSourceRoots();
        JavaModel.getJavaRepository().beginTrans(false);
        try {
            oldExp = exp;
            breakloop = false;
            for (Iterator it = cpRoots.iterator(); it.hasNext();) {
                if (breakloop)
                    return Collections.EMPTY_LIST;
                FileObject cpRoot = (FileObject)it.next();
                if (includeLibraryClasses || FileOwnerQuery.getOwner(cpRoot) != null) {
                    ClassIndex ci = ClassIndex.getIndex(JavaModel.getJavaExtent(cpRoot));
                    if (ci != null) {
                        List classes = ci.getClassesBySNPrefix(exp, caseSensitive);
                        for (Iterator classIt = classes.iterator(); classIt.hasNext();) {
                            JavaClass cls = (JavaClass)classIt.next();
                            if (breakloop)
                                return Collections.EMPTY_LIST;
                            if (includeInnerClasses || !cls.isInner())
                                ret.add(new NbJMIResultItem.ClassResultItem(cls, true, false, false));
                        }
                    }
                }
            }
            Collections.sort(ret, JMIUtils.getNaturalMemberNameComparator());
        } finally {
            oldExp = null;
            JavaModel.getJavaRepository().endTrans();
        }
        return ret;
    }
}
