/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.hints;

import java.text.Format;
import java.text.MessageFormat;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.TypeCast;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.modules.editor.hints.spi.ChangeInfo;
import org.netbeans.modules.editor.hints.spi.Hint;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.openide.util.NbBundle;

/**
 *
 * @author Jan Lahoda
 */
class AddCastJavaHint extends Hint {
    
    private static Format textFormat = new MessageFormat(NbBundle.getBundle(AddCastJavaHint.class).getString("Add_cast_to_X"));
    private Expression castedElement;
    private ClassDefinition castTo;
    private String text;
    
    AddCastJavaHint(String elementName, ClassDefinition castTo, Expression castedElement) {
        this.castTo = castTo;
        this.castedElement = castedElement;
        this.text = textFormat.format(new Object[] { elementName, GeneratorUtils.handleImport(castedElement.getResource(), castTo, true) });
    }

    public String getText() {
        return text;
    }
    
    public ChangeInfo implement() {
        boolean fail = true;
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            JavaModel.setClassPath(castedElement.getResource());
            TypeReference id = JavaModelUtil.resolveImportsForType(castedElement,castTo);
            
            if (castedElement instanceof TypeCast) {
                TypeCast typeCast=(TypeCast)castedElement;
                
                typeCast.setTypeName(id);
            } else {
                JavaModelPackage pckg = (JavaModelPackage)castedElement.refImmediatePackage();
                TypeCast typeCast = pckg.getTypeCast().createTypeCast();
                
                ((Element) castedElement.refImmediateComposite()).replaceChild(castedElement, typeCast);
                typeCast.setTypeName(id);
                typeCast.setExpression(castedElement);
            }
            fail = false;
        } finally {
            JavaModel.getJavaRepository().endTrans(fail);
        }
        return null;
    }
    
    public int getType() {
        return ERROR;
    }

}
