/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.hints;

import java.text.Format;
import java.text.MessageFormat;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.modules.editor.hints.spi.ChangeInfo;
import org.netbeans.modules.editor.hints.spi.Hint;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.openide.util.NbBundle;

/**
 *
 * @author Jan Lahoda
 */
class AddThrowsClauseJavaHint extends Hint {
    
    private static Format textFormat = new MessageFormat(NbBundle.getBundle(AddThrowsClauseJavaHint.class).getString("Add_throws_clause_for_X"));    
    private JavaClass exception;
    private CallableFeature method;
    private String text;
    
    AddThrowsClauseJavaHint(CallableFeature method, JavaClass exception) {
        this.exception = exception;
        this.method = method;        
        this.text = textFormat.format(new Object[] {exception.getName()});
    }

    public String getText() {
        return text;
    }

    public ChangeInfo implement() {
        boolean fail = true;
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            JavaModel.setClassPath(method.getResource());
            if (!method.getExceptions().contains(exception)) {
                MultipartId excId = JavaModelUtil.resolveImportsForClass(method,exception);
                
                method.getExceptionNames().add(excId);
            }
            fail = false;
        } finally {
            JavaModel.getJavaRepository().endTrans(fail);
        }
        return null;
    }
    
    public int getType() {
        return ERROR;
    }

}
