/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.hints;

import java.util.List;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.modules.editor.hints.spi.ChangeInfo;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.openide.util.NbBundle;

/**
 *
 * @author Tomas Hurka
 */
class CreateFieldJavaHint extends CreateElementJavaHint {

    private ClassDefinition javaClass;
    
    CreateFieldJavaHint(NamedElement symbol,ClassDefinition cls) {
        super(symbol);
        javaClass=cls;
        if (cls instanceof ParameterizedType) {
            javaClass=((ParameterizedType)cls).getDefinition();
        }
        hintText=NbBundle.getMessage(CreateFieldJavaHint.class, "MSG_CreateField", name, cls.getName());
    }
    
    public ChangeInfo implement() {
        boolean fail = true;
        Field newField;
        boolean bothInOneFile;
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            JavaModel.setClassPath(unresolvedSymbol.getResource());
            Type fieldType=DeclarationInfo.computeType(unresolvedSymbol);
            Resource classRes = javaClass.getResource();
            Resource unresRes = unresolvedSymbol.getResource();
            bothInOneFile = classRes.equals(unresRes);
            int modifiers=computeAccessModifiers(javaClass,unresRes);
            
            modifiers|=computeStaticModifier(unresolvedSymbol);
            newField=createField(modifiers,fieldType);
            fail = false;
        } finally {
            JavaModel.getJavaRepository().endTrans(fail);
        }
        ChangeInfo ch = PositionUtils.selectFieldType(newField);
        if (!bothInOneFile) addModified();
        
        return ch;
    }
    
    private Field createField(int modifiers,Type type) {
        JavaModelPackage pac=(JavaModelPackage)javaClass.refImmediatePackage();
        TypeReference typeRef=JavaModelUtil.resolveImportsForType(javaClass,type);        
        Field field = pac.getField().createField(name,null,modifiers,null,null,false,typeRef,0,null,null);
        List features=javaClass.getFeatures();
        int index = PositionUtils.getProposedFieldIndex(features);
        
        if (index == -1) {
            // insert fields at the beginning of the class
            index = 0;
        }
        features.add(index,field);
        return field;
    }

    
}
