/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.j2seproject.wsclient;
import java.io.File;
import java.net.UnknownHostException;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.J2SEProjectType;
import org.netbeans.modules.java.j2seproject.ui.customizer.J2SEProjectProperties;
import org.netbeans.modules.websvc.api.client.ClientStubDescriptor;
import org.netbeans.modules.websvc.api.client.WebServicesClientConstants;
import org.netbeans.modules.websvc.api.client.WsCompileClientEditorSupport;
import org.netbeans.modules.websvc.spi.client.WebServicesClientSupportImpl;
import java.io.IOException;
import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.netbeans.spi.project.support.ant.ReferenceHelper;


/**
 *
 * @author  rico
 * Implementation of WebServicesSupportImpl and WebServicesClientSupportImpl
 */
public class J2SEProjectWebServicesClientSupport implements WebServicesClientSupportImpl{

    private J2SEProject project;
    private AntProjectHelper helper;
    private ReferenceHelper referenceHelper;
    private String proxyHost,proxyPort;

    public static final String WSDL_FOLDER = "wsdl"; //NOI18N
            
    /** Creates a new instance of J2SEProjectWebServicesSupport */
    public J2SEProjectWebServicesClientSupport(J2SEProject project, AntProjectHelper helper, ReferenceHelper referenceHelper) {
        this.project = project;
        this.helper = helper;
        this.referenceHelper = referenceHelper;
    }
            
    public AntProjectHelper getAntProjectHelper() {
        return helper;
    }
       
    public ReferenceHelper getReferenceHelper(){
        return referenceHelper;
    }

    // Implementation of WebServiceClientSupportImpl
    public void addServiceClient(String serviceName, String packageName, String sourceUrl, FileObject configFile, ClientStubDescriptor stubDescriptor) {
        this.addServiceClient(serviceName, packageName, sourceUrl, configFile, stubDescriptor, null);
    }
    
    // Implementation of WebServiceClientSupportImpl
    public void addServiceClient(String serviceName, String packageName, String sourceUrl, FileObject configFile, ClientStubDescriptor stubDescriptor, String[] wscompileFeatures) {
        // !PW FIXME I have two concerns with this implementation:
        // 1. Since it modifies project.xml, I suspect it should be acquiring
        //    ProjectManager.mutex() for write access.
        // 2. It seems like it ought to be implemented via the AuxiliaryConfiguration
        //    interface.
        boolean needsSave = false;
        boolean modifiedProjectProperties = false;
        boolean modifiedPrivateProperties = false;
        
        /** Locate root of web service client node structure in project,xml, creating it
         *  if it's not found.
         */
        Element data = helper.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        NodeList nodes = data.getElementsByTagName(WebServicesClientConstants.WEB_SERVICE_CLIENTS);
        Element clientElements = null;
        
        if(nodes.getLength() == 0) {
            // 'needsSave' deliberately left false here because this is a trival change
            // that only should be saved if additional changes are also made below.
            clientElements = doc.createElementNS(J2SEProjectType.PROJECT_CONFIGURATION_NAMESPACE, WebServicesClientConstants.WEB_SERVICE_CLIENTS);
            NodeList srcRoots = data.getElementsByTagNameNS(J2SEProjectType.PROJECT_CONFIGURATION_NAMESPACE, "source-roots"); // NOI18N
            assert srcRoots.getLength() == 1 : "Invalid project.xml."; // NOI18N
            data.insertBefore(clientElements, srcRoots.item(0));
        } else {
            clientElements = (Element) nodes.item(0);
        }
        
        /** Make sure this service is not already registered in project.xml
         */
        boolean serviceAlreadyAdded = false;
        NodeList clientNameList = clientElements.getElementsByTagNameNS(J2SEProjectType.PROJECT_CONFIGURATION_NAMESPACE, WebServicesClientConstants.WEB_SERVICE_CLIENT_NAME);
        for(int i = 0; i < clientNameList.getLength(); i++ ) {
            Element clientNameElement = (Element) clientNameList.item(i);
            NodeList nl = clientNameElement.getChildNodes();
            if(nl.getLength() >= 1) {
                org.w3c.dom.Node n = nl.item(0);
                if(n.getNodeType() == org.w3c.dom.Node.TEXT_NODE) {
                    if(serviceName.equalsIgnoreCase(n.getNodeValue())) {
                        serviceAlreadyAdded = true;
                        
                        // !PW FIXME should force stub type to match value passed in
                        // in case someone is overwriting a current service with a different
                        // stub type.
                    }
                }
            }
        }
        
        /** Add entry for the client to project.xml and regenerate build-impl.xml.
         */
        if(!serviceAlreadyAdded) {
            Element clientElement = doc.createElementNS(J2SEProjectType.PROJECT_CONFIGURATION_NAMESPACE, WebServicesClientConstants.WEB_SERVICE_CLIENT);
            clientElements.appendChild(clientElement);
            Element clientElementName = doc.createElementNS(J2SEProjectType.PROJECT_CONFIGURATION_NAMESPACE, WebServicesClientConstants.WEB_SERVICE_CLIENT_NAME);
            clientElement.appendChild(clientElementName);
            clientElementName.appendChild(doc.createTextNode(serviceName));
            Element clientElementStubType = doc.createElementNS(J2SEProjectType.PROJECT_CONFIGURATION_NAMESPACE, WebServicesClientConstants.WEB_SERVICE_STUB_TYPE);
            clientElement.appendChild(clientElementStubType);
            clientElementStubType.appendChild(doc.createTextNode(stubDescriptor.getName()));
            Element clientElementSourceUrl = doc.createElementNS(J2SEProjectType.PROJECT_CONFIGURATION_NAMESPACE, WebServicesClientConstants.CLIENT_SOURCE_URL);
            clientElement.appendChild(clientElementSourceUrl);
            clientElementSourceUrl.appendChild(doc.createTextNode(sourceUrl));
            helper.putPrimaryConfigurationData(data, true);
            needsSave = true;
        }
        
        EditableProperties projectProperties = helper.getProperties(AntProjectHelper.PROJECT_PROPERTIES_PATH);
        EditableProperties privateProperties = helper.getProperties(AntProjectHelper.PRIVATE_PROPERTIES_PATH);
        // Add property for wscompile features
        {
            String featurePropertyName = "wscompile.client." + serviceName + ".features"; // NOI18N
            String defaultFeatures = "wsi, strict"; // NOI18N -- defaults if stub descriptor is bad type (should never happen?)
            if(stubDescriptor instanceof JAXRPCClientStubDescriptor) {
                JAXRPCClientStubDescriptor stubDesc = (JAXRPCClientStubDescriptor) stubDescriptor;
                if (wscompileFeatures!=null) stubDesc.setDefaultFeatures(wscompileFeatures);
                defaultFeatures = stubDesc.getDefaultFeaturesAsArgument();
            } else {
                // !PW FIXME wrong stub type -- log error message.
            }
            String oldFeatures = projectProperties.getProperty(featurePropertyName);
            if(!defaultFeatures.equals(oldFeatures)) {
                projectProperties.put(featurePropertyName, defaultFeatures);
                modifiedProjectProperties = true;
            }
        }
        
        // Add package name property
        {
            String packagePropertyName = "wscompile.client." + serviceName + ".package"; // NOI18N
            String oldPackageName = projectProperties.getProperty(packagePropertyName);
            if(!packageName.equals(oldPackageName)) {
                projectProperties.put(packagePropertyName, packageName);
                modifiedProjectProperties = true;
            }
        }
        
        // Add http.proxyHost, http.proxyPort and http.nonProxyHosts JVM options
        // create wscompile:httpproxy property
        if (proxyHost!=null && proxyHost.length()>0) {
            boolean modif = addJVMProxyOptions(projectProperties,proxyHost,proxyPort);
            if (modif) modifiedProjectProperties = true;
            String proxyProperty = "wscompile.client." + serviceName + ".proxy"; // NOI18N
            String oldProxyProperty = privateProperties.getProperty(proxyProperty);
            if(!proxyProperty.equals(oldProxyProperty)) {
                privateProperties.put(proxyProperty, proxyHost+":"+(proxyPort==null?"8080":proxyPort)); //NOI18N
                modifiedPrivateProperties = true;
            }
        }
        
        if(modifiedProjectProperties) {
            helper.putProperties(AntProjectHelper.PROJECT_PROPERTIES_PATH, projectProperties);
            needsSave = true;
        }
        if(modifiedPrivateProperties) {
            helper.putProperties(AntProjectHelper.PRIVATE_PROPERTIES_PATH, privateProperties);
            needsSave = true;
        }
        
        // Update wscompile related properties.  boolean return indicates whether
        // any changes were made.
        if(updateWsCompileProperties(serviceName)) {
            needsSave = true;
        }
        
        // !PW Lastly, save the project if we actually made any changes to any
        // properties or the build script.
        if(needsSave) {
            try {
                ProjectManager.getDefault().saveProject(project);
            } catch(IOException ex) {
                NotifyDescriptor desc = new NotifyDescriptor.Message(
                NbBundle.getMessage(J2SEProjectWebServicesClientSupport.class,"MSG_ErrorSavingOnWSClientAdd", serviceName, ex.getMessage()), // NOI18N
                NotifyDescriptor.ERROR_MESSAGE);
                DialogDisplayer.getDefault().notify(desc);
            }
        }
    }
    
    public void addInfrastructure(String implBeanClass, FileObject pkg) {
        //nothing to do here, there are no infrastructure elements
    }
    
    public FileObject getDeploymentDescriptor() {
        return null;
    }
        
    private FileObject getFileObject(String propname) {
        String prop = helper.getStandardPropertyEvaluator().getProperty(propname);
        if (prop != null) {
            return helper.resolveFileObject(prop);
        } else {
            return null;
        }
    }
    
    private boolean updateWsCompileProperties(String serviceName) {
        /** Ensure wscompile.classpath and wscompile.tools.classpath are
         *  properly defined.
         *
         *  wscompile.classpath goes in project properties and includes
         *  jaxrpc and qname right now.
         *
         *  wscompile.tools.classpath is for tools.jar which is needed when
         *  running under the Sun JDK to invoke javac.  It is placed in
         *  user.properties so that if we compute it incorrectly (say on a mac)
         *  the user can change it and we will not blow away the change.
         *  Hopefully we can do this better for release.
         */
        boolean globalPropertiesChanged = false;
        
        EditableProperties globalProperties = PropertyUtils.getGlobalProperties();
        if(globalProperties.getProperty(WebServicesClientConstants.WSCOMPILE_TOOLS_CLASSPATH) == null) {
            globalProperties.setProperty(WebServicesClientConstants.WSCOMPILE_TOOLS_CLASSPATH, "${java.home}\\..\\lib\\tools.jar"); // NOI18N
            
            try {
                PropertyUtils.putGlobalProperties(globalProperties);
            } catch(IOException ex) {
                NotifyDescriptor desc = new NotifyDescriptor.Message(
                NbBundle.getMessage(J2SEProjectWebServicesClientSupport.class,"MSG_ErrorSavingGlobalProperties", serviceName, ex.getMessage()), // NOI18N
                NotifyDescriptor.ERROR_MESSAGE);
                DialogDisplayer.getDefault().notify(desc);
            }
            
            globalPropertiesChanged = true;
        }
        
        
        boolean projectPropertiesChanged = false;
        EditableProperties projectProperties = helper.getProperties(AntProjectHelper.PROJECT_PROPERTIES_PATH);
        
        { // Block that adjusts wscompile.client.classpath as necessary.
            HashSet wscJars = new HashSet();
            boolean newWscJars = false;
            String wscClientClasspath = projectProperties.getProperty(WebServicesClientConstants.WSCOMPILE_CLASSPATH);
            if (wscClientClasspath == null) {
                wscClientClasspath = "${" + WebServicesClientConstants.WSCOMPILE_TOOLS_CLASSPATH + "}" + ":${javac.classpath}";
                projectProperties.put(WebServicesClientConstants.WSCOMPILE_CLASSPATH, wscClientClasspath);
                projectPropertiesChanged = true;
            }
            
//            for(int i = 0; i < WSCOMPILE_JARS.length; i++) {
//                if(!wscJars.contains(WSCOMPILE_JARS[i])) {
//                    wscJars.add(WSCOMPILE_JARS[i]);
//                    newWscJars = true;
//                }
//            }
            
//            if(newWscJars) {
//                StringBuffer newClasspathBuf = new StringBuffer(256);
//                for(Iterator iter = wscJars.iterator(); iter.hasNext(); ) {
//                    newClasspathBuf.append(iter.next().toString());
//                    if(iter.hasNext()) {
//                        newClasspathBuf.append(":");
//                    }
//                }
//                projectProperties.put(WSCOMPILE_CLASSPATH, newClasspathBuf.toString());
//                projectPropertiesChanged = true;
//            }
        }
        
        // set tools.jar property if not set
        if(projectProperties.getProperty(WebServicesClientConstants.WSCOMPILE_TOOLS_CLASSPATH) == null) {
            projectProperties.setProperty(WebServicesClientConstants.WSCOMPILE_TOOLS_CLASSPATH, "${java.home}\\..\\lib\\tools.jar"); // NOI18N
            projectPropertiesChanged = true;
        }
        
        if(projectPropertiesChanged) {
            helper.putProperties(AntProjectHelper.PROJECT_PROPERTIES_PATH, projectProperties);
        }
        
        return globalPropertiesChanged || projectPropertiesChanged;
    }
    
    public void removeServiceClient(String serviceName) {
        // 2. Remove service from project.xml
        //    Side effect: Regenerate build-impl.xsl
        //    Optional - if last service, remove properties we generated.
        boolean needsSave = false;
        boolean needsSave1 = false;
        
        /** Remove properties from project.properties
         */
        String featureProperty = "wscompile.client." + serviceName + ".features"; // NOI18N
        String packageProperty = "wscompile.client." + serviceName + ".package"; // NOI18N
        String proxyProperty = "wscompile.client." + serviceName + ".proxy"; //NOI18N
        
        EditableProperties ep =  helper.getProperties(AntProjectHelper.PROJECT_PROPERTIES_PATH);
        EditableProperties ep1 =  helper.getProperties(AntProjectHelper.PRIVATE_PROPERTIES_PATH);
        
        if(ep.getProperty(featureProperty) != null) {
            ep.remove(featureProperty);
            needsSave = true;
        }
        
        if(ep.getProperty(packageProperty) != null) {
            ep.remove(packageProperty);
            needsSave = true;
        }
        
        if(ep1.getProperty(proxyProperty) != null) {
            ep1.remove(proxyProperty);
            needsSave1 = true;
        }
        
        if(needsSave) {
            helper.putProperties(AntProjectHelper.PROJECT_PROPERTIES_PATH, ep);
        }
        
        if(needsSave1) {
            helper.putProperties(AntProjectHelper.PRIVATE_PROPERTIES_PATH, ep1);
        }
        
        /** Locate root of web service client node structure in project,xml
         */
        Element data = helper.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        NodeList nodes = data.getElementsByTagName(WebServicesClientConstants.WEB_SERVICE_CLIENTS);
        Element clientElements = null;
        
        /* If there is a root, get all the names of the child services and search
         * for the one we want to remove.
         */
        if(nodes.getLength() >= 1) {
            clientElements = (Element) nodes.item(0);
            NodeList clientNameList = clientElements.getElementsByTagNameNS(J2SEProjectType.PROJECT_CONFIGURATION_NAMESPACE, WebServicesClientConstants.WEB_SERVICE_CLIENT_NAME);
            for(int i = 0; i < clientNameList.getLength(); i++ ) {
                Element clientNameElement = (Element) clientNameList.item(i);
                NodeList nl = clientNameElement.getChildNodes();
                if(nl.getLength() == 1) {
                    org.w3c.dom.Node n = nl.item(0);
                    if(n.getNodeType() == org.w3c.dom.Node.TEXT_NODE) {
                        if(serviceName.equalsIgnoreCase(n.getNodeValue())) {
                            // Found it!  Now remove it.
                            org.w3c.dom.Node serviceNode = clientNameElement.getParentNode();
                            clientElements.removeChild(serviceNode);
                            helper.putPrimaryConfigurationData(data, true);
                            needsSave = true;
                        }
                    }
                }
            }
        }
        
        // !PW Lastly, save the project if we actually made any changes to any
        // properties or the build script.
        if(needsSave || needsSave1) {
            try {
                ProjectManager.getDefault().saveProject(project);
            } catch(IOException ex) {
                NotifyDescriptor desc = new NotifyDescriptor.Message(
                NbBundle.getMessage(J2SEProjectWebServicesClientSupport.class,"MSG_ErrorSavingOnWSClientRemove", serviceName, ex.getMessage()), // NOI18N
                NotifyDescriptor.ERROR_MESSAGE);
                DialogDisplayer.getDefault().notify(desc);
            }
        }
    }
    
    public FileObject getWsdlFolder(boolean create) throws IOException {

        EditableProperties ep =  helper.getProperties(AntProjectHelper.PROJECT_PROPERTIES_PATH);
        String metaInfStr = helper.getStandardPropertyEvaluator().getProperty("meta.inf.dir");
        String wsdlFolderStr = metaInfStr + "/" + WSDL_FOLDER; // NOI18N
        FileObject wsdlFolder = project.getProjectDirectory().getFileObject(wsdlFolderStr);
        if (wsdlFolder == null && create) {
            wsdlFolder = FileUtil.createFolder(project.getProjectDirectory(), wsdlFolderStr);
        }
        
        return wsdlFolder;
    }
    
    public List/*ClientStubDescriptor*/ getStubDescriptors() {
        ArrayList stubs = new ArrayList(2);
        stubs.add(jaxrpcClientStub);
        return stubs;
    }
    
    private boolean isProjectOpened() {
        Project[] projects = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projects.length; i++) {
            if (projects[i].equals(project))
                return true;
        }
        return false;
    }
    
    /** !PW This method is exposed in the client support API.  Though it's
     *  implementation makes more sense here than anywhere else, perhaps this
     *  and the other project.xml/project.properties related methods in this
     *  object should be refactored into another object that this one delegates
     *  to.  That way, this method would be directly available within the web
     *  web module, as it is needed, and remain missing from the API (where it
     *  probably does not belong at this time.
     */
    private static final String [] WSCOMPILE_CLIENT_FEATURES = {
        "datahandleronly", // - portable
        //        "documentliteral", // SEI ONLY
        //        "rpcliteral", // SEI ONLY
        "explicitcontext",
        //        "infix:<name>", // difficult to implement.
        "jaxbenumtype",
        "nodatabinding", //  - portable
        "noencodedtypes",
        "nomultirefs",
        "norpcstructures", //  - portable
        "novalidation", //  - portable
        "resolveidref",
        "searchschema", //  - portable
        "serializeinterfaces",
        "strict", //  - portable
        //        "useonewayoperations", // SEI ONLY
        "wsi", // - portable
        "unwrap",// - portable
        "donotoverride", // - portable
        "donotunwrap", // - portable
    };
    
    private static final List allClientFeatures = Arrays.asList(WSCOMPILE_CLIENT_FEATURES);
    
    private static final String [] WSCOMPILE_KEY_CLIENT_FEATURES = {
        "wsi",
        "strict",
        "norpcstructures",
        "unwrap",
        "donotunwrap",
        "donotoverride",
        "datahandleronly",
        "nodatabinding",
        "novalidation",
        "searchschema",
    };
    
    private static final List importantClientFeatures = Arrays.asList(WSCOMPILE_KEY_CLIENT_FEATURES);
    
    public List getServiceClients() {
        List serviceNames = new ArrayList();
        
        Element data = helper.getPrimaryConfigurationData(true);
        NodeList nodes = data.getElementsByTagName(WebServicesClientConstants.WEB_SERVICE_CLIENTS);
        EditableProperties projectProperties = helper.getProperties(AntProjectHelper.PROJECT_PROPERTIES_PATH);
        
        if(nodes.getLength() != 0) {
            Element clientElements = (Element) nodes.item(0);
            NodeList clientNameList = clientElements.getElementsByTagNameNS(
            J2SEProjectType.PROJECT_CONFIGURATION_NAMESPACE, WebServicesClientConstants.WEB_SERVICE_CLIENT_NAME);
            for(int i = 0; i < clientNameList.getLength(); i++ ) {
                Element clientNameElement = (Element) clientNameList.item(i);
                NodeList nl = clientNameElement.getChildNodes();
                if(nl.getLength() == 1) {
                    org.w3c.dom.Node n = nl.item(0);
                    if(n.getNodeType() == org.w3c.dom.Node.TEXT_NODE) {
                        String serviceName = n.getNodeValue();
                        String currentFeatures = projectProperties.getProperty("wscompile.client." + serviceName + ".features"); //NOI18N
                        if(currentFeatures == null) {
                            // !PW should probably retrieve default features for stub type.
                            // For now, this will work because this is the same value we'd get doing that.
                            //
                            // Defaults if we can't find any feature property for this client
                            // Mostly for upgrading EA1, EA2 projects which did not have
                            // this property, but also useful if the user deletes it from
                            // project.properties.
                            currentFeatures = "wsi, strict";
                        }
                        ClientStubDescriptor stubType = getClientStubDescriptor(clientNameElement.getParentNode());
                        boolean propVerbose = "true".equalsIgnoreCase( //NOI18N
                                projectProperties.getProperty("wscompile.client." + serviceName + ".verbose")); //NOI18N
                        boolean propDebug = "true".equalsIgnoreCase( //NOI18N
                                projectProperties.getProperty("wscompile.client." + serviceName + ".debug")); //NOI18N                
                        boolean propPrintStackTrace = "true".equalsIgnoreCase( //NOI18N
                                projectProperties.getProperty("wscompile.client." + serviceName + ".xPrintStackTrace")); //NOI18N
                        boolean propExtensible = "true".equalsIgnoreCase( //NOI18N
                                projectProperties.getProperty("wscompile.client." + serviceName + ".xSerializable")); //NOI18N
                        boolean propOptimize = "true".equalsIgnoreCase( //NOI18N
                                projectProperties.getProperty("wscompile.client." + serviceName + ".optimize")); //NOI18N
                        boolean[] options = new boolean[] { //NOI18N
                            propVerbose,propDebug,propPrintStackTrace,propExtensible,propOptimize
                        };
                        WsCompileClientEditorSupport.ServiceSettings settings = new WsCompileClientEditorSupport.ServiceSettings(
                        serviceName, stubType, options, currentFeatures, allClientFeatures, importantClientFeatures);
                        serviceNames.add(settings);
                    } else {
                        // !PW FIXME node is wrong type?! - log message or trace?
                    }
                } else {
                    // !PW FIXME no name for this service entry - notify user
                }
            }
        }
        
        return serviceNames;
    }
    
    private ClientStubDescriptor getClientStubDescriptor(org.w3c.dom.Node parentNode) {
        ClientStubDescriptor result = null;
        
        if(parentNode instanceof Element) {
            Element parentElement = (Element) parentNode;
            NodeList clientNameList = parentElement.getElementsByTagNameNS(
            J2SEProjectType.PROJECT_CONFIGURATION_NAMESPACE, WebServicesClientConstants.WEB_SERVICE_STUB_TYPE);
            if(clientNameList.getLength() == 1) {
                Element clientStubElement = (Element) clientNameList.item(0);
                NodeList nl = clientStubElement.getChildNodes();
                if(nl.getLength() == 1) {
                    org.w3c.dom.Node n = nl.item(0);
                    if(n.getNodeType() == org.w3c.dom.Node.TEXT_NODE) {
                        String stubName = n.getNodeValue();
                        if (ClientStubDescriptor.JAXRPC_CLIENT_STUB.equals(stubName)) {
                            result = jaxrpcClientStub;
                        }
                    }
                }
            }
        }
        
        return result;
    }
    
    public String getWsdlSource(String serviceName) {
        Element data = helper.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        String wsdlSource = null;
        
        Element clientElement = getWebServiceClientNode(data, serviceName);
        if(clientElement != null) {
            NodeList fromWsdlList = clientElement.getElementsByTagNameNS(
            J2SEProjectType.PROJECT_CONFIGURATION_NAMESPACE, WebServicesClientConstants.CLIENT_SOURCE_URL);
            if(fromWsdlList.getLength() == 1) {
                Element fromWsdlElement = (Element) fromWsdlList.item(0);
                NodeList nl = fromWsdlElement.getChildNodes();
                if(nl.getLength() == 1) {
                    org.w3c.dom.Node n = nl.item(0);
                    if(n.getNodeType() == org.w3c.dom.Node.TEXT_NODE) {
                        wsdlSource = n.getNodeValue();
                    }
                }
            }
        }
        
        return wsdlSource;
    }
    
    public void setWsdlSource(String serviceName, String wsdlSource) {
        Element data = helper.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        boolean needsSave = false;
        
        Element clientElement = getWebServiceClientNode(data, serviceName);
        if(clientElement != null) {
            NodeList fromWsdlList = clientElement.getElementsByTagNameNS(
            J2SEProjectType.PROJECT_CONFIGURATION_NAMESPACE, WebServicesClientConstants.CLIENT_SOURCE_URL);
            if(fromWsdlList.getLength() > 0) {
                Element fromWsdlElement = (Element) fromWsdlList.item(0);
                NodeList nl = fromWsdlElement.getChildNodes();
                if(nl.getLength() > 0) {
                    org.w3c.dom.Node n = nl.item(0);
                    n.setNodeValue(wsdlSource);
                } else {
                    fromWsdlElement.appendChild(doc.createTextNode(wsdlSource));
                }
            } else {
                Element clientElementSourceUrl = doc.createElementNS(J2SEProjectType.PROJECT_CONFIGURATION_NAMESPACE, WebServicesClientConstants.CLIENT_SOURCE_URL);
                clientElement.appendChild(clientElementSourceUrl);
                clientElementSourceUrl.appendChild(doc.createTextNode(wsdlSource));
            }
            
            needsSave = true;
        }
        
        // !PW Save the project if we were able to make the change.
        if(needsSave) {
            try {
                ProjectManager.getDefault().saveProject(project);
            } catch(IOException ex) {
                NotifyDescriptor desc = new NotifyDescriptor.Message(
                NbBundle.getMessage(J2SEProjectWebServicesClientSupport.class,"MSG_ErrorSavingOnWSClientAdd", serviceName, ex.getMessage()), // NOI18N
                NotifyDescriptor.ERROR_MESSAGE);
                DialogDisplayer.getDefault().notify(desc);
            }
        }
    }
    
    private Element getWebServiceClientNode(Element data, String serviceName) {
        Element clientElement = null;
        NodeList nodes = data.getElementsByTagName(WebServicesClientConstants.WEB_SERVICE_CLIENTS);
        
        if(nodes.getLength() != 0) {
            Element clientElements = (Element) nodes.item(0);
            NodeList clientNameList = clientElements.getElementsByTagNameNS(
            J2SEProjectType.PROJECT_CONFIGURATION_NAMESPACE, WebServicesClientConstants.WEB_SERVICE_CLIENT_NAME);
            for(int i = 0; i < clientNameList.getLength(); i++ ) {
                Element clientNameElement = (Element) clientNameList.item(i);
                NodeList nl = clientNameElement.getChildNodes();
                if(nl.getLength() == 1) {
                    org.w3c.dom.Node n = nl.item(0);
                    if(n.getNodeType() == org.w3c.dom.Node.TEXT_NODE) {
                        String name = n.getNodeValue();
                        if(serviceName.equals(name)) {
                            org.w3c.dom.Node node = clientNameElement.getParentNode();
                            clientElement = (node instanceof Element) ? (Element) node : null;
                            break;
                        }
                    } else {
                        // !PW FIXME node is wrong type?! - log message or trace?
                    }
                }
            }
        }
        
        return clientElement;
    }
    
    private static final JAXRPCClientStubDescriptor jaxrpcClientStub = new JAXRPCClientStubDescriptor(
        ClientStubDescriptor.JAXRPC_CLIENT_STUB,
        NbBundle.getMessage(J2SEProjectWebServicesClientSupport.class,"LBL_JAXRPCStaticClientStub"),
        new String [] { "wsi", "strict" });

    public void addServiceClientReference(String serviceName, String fqServiceName, String relativeWsdlPath, String relativeMappingPath, String[] portSEIInfo) {
        // nothing to do in J2se
    }
    
    /** Stub descriptor for services and clients supported by this project type.
     */
    private static class JAXRPCClientStubDescriptor extends ClientStubDescriptor {
        
        private String [] defaultFeatures;
        
        public JAXRPCClientStubDescriptor(String name, String displayName, String [] defaultFeatures) {
            super(name, displayName);
            
            this.defaultFeatures = defaultFeatures;
        }
        
        public String [] getDefaultFeatures() {
            return defaultFeatures;
        }
        
        public String getDefaultFeaturesAsArgument() {
            StringBuffer buf = new StringBuffer(defaultFeatures.length*32);
            for(int i = 0; i < defaultFeatures.length; i++) {
                if(i > 0) {
                    buf.append(",");
                }
                
                buf.append(defaultFeatures[i]);
            }
            return buf.toString();
        }
        
        void setDefaultFeatures(String[] defaultFeatures) {
            this.defaultFeatures=defaultFeatures;
        }
    }
    
    public void setProxyJVMOptions(String proxyHost, String proxyPort) {
        this.proxyHost=proxyHost;
        this.proxyPort=proxyPort;
    }
    
    private static final String PROXY_HOST_OPTION="-Dhttp.proxyHost"; //NOI18N
    private static final String PROXY_PORT_OPTION="-Dhttp.proxyPort"; //NOI18N
    private static final String NON_PROXY_HOSTS_OPTION="-Dhttp.nonProxyHosts"; //NOI18N
    
    private boolean addJVMProxyOptions(EditableProperties prop, String proxyHost, String proxyPort) {
        String jvmOptions = prop.getProperty(J2SEProjectProperties.RUN_JVM_ARGS);
        boolean modif=false;
        String localHosts = "localhost"; //NOI18N 
        try {
            localHosts = java.net.InetAddress.getLocalHost().getCanonicalHostName();
        } catch (java.net.UnknownHostException ex) {}
        if (!"localhost".equals(localHosts)) localHosts="\""+localHosts+"|localhost\""; //NOI18N
        if (jvmOptions==null || jvmOptions.length()==0) {
            jvmOptions = PROXY_HOST_OPTION+"="+proxyHost+ //NOI18N
                    " "+PROXY_PORT_OPTION+"="+proxyPort+ //NOI18N
                    " "+NON_PROXY_HOSTS_OPTION+"="+localHosts; //NOI18N
            modif=true;
        } else {
            if (jvmOptions.indexOf(PROXY_HOST_OPTION)<0) {
                jvmOptions+=" "+PROXY_HOST_OPTION+"="+proxyHost; //NOI18N
                modif=true;
            }
            if (jvmOptions.indexOf(PROXY_PORT_OPTION)<0) {
                jvmOptions+=" "+PROXY_PORT_OPTION+"="+proxyPort; //NOI18N
                modif=true;
            }
            if (jvmOptions.indexOf(NON_PROXY_HOSTS_OPTION)<0) {
                jvmOptions+=" "+NON_PROXY_HOSTS_OPTION+"="+localHosts; //NOI18N
                modif=true;
            }
        }
        if (modif) prop.setProperty(J2SEProjectProperties.RUN_JVM_ARGS,jvmOptions);
        return modif;
    }

    public String getServiceRefName(String serviceName) {
        //noop
        return null;
    }
    
}
